/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.scv.dominion.grpc;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.opennms.dominion.local.rpc.grpc.DominionGrpc;
import org.opennms.features.minion.dominion.grpc.DominionScvGrpcClient;
import org.opennms.features.scv.api.Credentials;
import org.opennms.features.scv.api.SecureCredentialsVault;

public class DominionSecureCredentialsVault
implements SecureCredentialsVault {
    private final DominionScvGrpcClient client;

    public DominionSecureCredentialsVault(DominionScvGrpcClient client) {
        this.client = Objects.requireNonNull(client);
    }

    public Set<String> getAliases() {
        return new HashSet<String>((Collection<String>)this.client.getAliases().getAliasesList());
    }

    public Credentials getCredentials(String alias) {
        Objects.requireNonNull(alias);
        DominionGrpc.ScvGetCredentialsResponse response = this.client.getCredentials(alias);
        return new Credentials(response.getUser(), response.getPassword(), response.getAttributesMap());
    }

    public void setCredentials(String alias, Credentials credentials) {
        Objects.requireNonNull(alias);
        Objects.requireNonNull(credentials);
        this.client.setCredentials(alias, credentials.getUsername(), credentials.getPassword(), credentials.getAttributes());
    }

    public void deleteCredentials(String alias) {
        Objects.requireNonNull(alias);
        throw new IllegalStateException("Not implemented yet");
    }
}

