/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.mirroring;

import io.netty.buffer.ByteBuf;
import java.util.Optional;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.BmpParser;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerFlags;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerInfo;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.packets.mirroring.Mirroring;

public class Information
implements Mirroring {
    public final Code code;

    public Information(ByteBuf buffer, PeerFlags flags, Optional<PeerInfo> peerInfo) {
        this.code = Code.from(BufferUtils.uint16((ByteBuf)buffer));
    }

    @Override
    public void accept(Mirroring.Visitor visitor) {
        visitor.visit(this);
    }

    public static enum Code {
        ERRORED_PDU,
        MESSAGES_LOST,
        UNKNOWN;


        private static Code from(int code) {
            switch (code) {
                case 0: {
                    return ERRORED_PDU;
                }
                case 1: {
                    return MESSAGES_LOST;
                }
            }
            BmpParser.RATE_LIMITED_LOG.debug("Unknown Mirroring Information Code: {}", (Object)code);
            return UNKNOWN;
        }
    }
}

