/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Objects;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.BmpParser;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.Attribute;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerFlags;

public class ExtendedV6Communities
implements Attribute {
    public final List<ExtendedV6Community> extendedCommunities;

    public ExtendedV6Communities(ByteBuf buffer, PeerFlags flags) {
        this.extendedCommunities = BufferUtils.repeatRemaining((ByteBuf)buffer, b -> new ExtendedV6Community(b, flags));
    }

    @Override
    public void accept(Attribute.Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("extendedV6Communities", this.extendedCommunities).toString();
    }

    public static class ExtendedV6Community {
        public final boolean authoritative;
        public final boolean transitive;
        public final int highType;
        public final int lowType;
        public final Value value;

        public ExtendedV6Community(ByteBuf buffer, PeerFlags flags) {
            int highType = BufferUtils.uint8((ByteBuf)buffer);
            this.authoritative = (highType >> 7 & 1) == 1;
            this.transitive = (highType >> 6 & 1) == 1;
            this.highType = highType & 0x3F;
            this.lowType = BufferUtils.uint8((ByteBuf)buffer);
            this.value = ExtendedV6Community.parseValue(this.authoritative, this.highType, this.lowType, BufferUtils.slice((ByteBuf)buffer, (int)18));
        }

        private static Value parseValue(boolean authoritative, int highType, int lowType, ByteBuf buffer) {
            switch (highType | (authoritative ? 1 : 0) << 7) {
                case 0: {
                    return ExtendedV6Community.parseSpecific(buffer, lowType);
                }
            }
            BmpParser.RATE_LIMITED_LOG.debug("Unknown Extended IPv6 Community Attribute: {}", (Object)highType);
            return null;
        }

        private static Value parseSpecific(ByteBuf buffer, int lowType) {
            String global = InetAddressUtils.toIpAddrString((byte[])BufferUtils.bytes((ByteBuf)buffer, (int)16));
            String local = Integer.toString(BufferUtils.uint16((ByteBuf)buffer));
            String value = String.format("%s:%s", global, local);
            switch (lowType) {
                case 2: {
                    return new Value("rt", value);
                }
                case 3: {
                    return new Value("soo", value);
                }
                case 11: {
                    return new Value("import", value);
                }
                case 12: {
                    return new Value("flowspec-redir", value);
                }
                case 16: {
                    return new Value("vpn-id", value);
                }
                case 18: {
                    return new Value("p2mp-nh", value);
                }
            }
            BmpParser.RATE_LIMITED_LOG.debug("Unknown Extended Community Attribute (IPv4): Common: {}", (Object)lowType);
            return null;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("authoritative", this.authoritative).add("transitive", this.transitive).add("highType", this.highType).add("lowType", this.lowType).add("value", (Object)this.value).toString();
        }

        public static class Value {
            public final String type;
            public final String value;

            public Value(String type, String value) {
                this.type = Objects.requireNonNull(type);
                this.value = Objects.requireNonNull(value);
            }
        }
    }
}

