/*
 * Decompiled with CFR 0.152.
 */
package org.dhcp4java;

import java.io.Serializable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dhcp4java.Util;

public class InetCidr
implements Serializable,
Comparable<InetCidr> {
    private final int m_nAddr;
    private final int m_nMask;
    private static final String[] CIDR_MASKS = new String[]{"128.0.0.0", "192.0.0.0", "224.0.0.0", "240.0.0.0", "248.0.0.0", "252.0.0.0", "254.0.0.0", "255.0.0.0", "255.128.0.0", "255.192.0.0", "255.224.0.0", "255.240.0.0", "255.248.0.0", "255.252.0.0", "255.254.0.0", "255.255.0.0", "255.255.128.0", "255.255.192.0", "255.255.224.0", "255.255.240.0", "255.255.248.0", "255.255.252.0", "255.255.254.0", "255.255.255.0", "255.255.255.128", "255.255.255.192", "255.255.255.224", "255.255.255.240", "255.255.255.248", "255.255.255.252", "255.255.255.254", "255.255.255.255"};
    private static final Map<InetAddress, Integer> CIDR = new HashMap<InetAddress, Integer>(48);
    private static final long[] CIDR_MASK_LONG = new long[1 + CIDR_MASKS.length];

    public InetCidr(InetAddress inetAddress, int n) {
        if (inetAddress == null) {
            throw new NullPointerException("addr is null");
        }
        if (!(inetAddress instanceof Inet4Address)) {
            throw new IllegalArgumentException("Only IPv4 addresses supported");
        }
        if (n < 1 || n > 32) {
            throw new IllegalArgumentException("Bad mask:" + n + " must be between 1 and 32");
        }
        this.m_nAddr = Util.inetAddress2Int(inetAddress) & (int)CIDR_MASK_LONG[n];
        this.m_nMask = n;
    }

    public InetCidr(InetAddress inetAddress, InetAddress inetAddress2) {
        if (inetAddress == null || inetAddress2 == null) {
            throw new NullPointerException();
        }
        if (!(inetAddress instanceof Inet4Address) || !(inetAddress2 instanceof Inet4Address)) {
            throw new IllegalArgumentException("Only IPv4 addresses supported");
        }
        Integer n = CIDR.get(inetAddress2);
        if (n == null) {
            throw new IllegalArgumentException("netmask: " + inetAddress2 + " is not a valid mask");
        }
        this.m_nAddr = Util.inetAddress2Int(inetAddress) & (int)CIDR_MASK_LONG[n];
        this.m_nMask = n;
    }

    public String toString() {
        return Util.int2InetAddress(this.m_nAddr).getHostAddress() + '/' + this.m_nMask;
    }

    public InetAddress getAddr() {
        return Util.int2InetAddress(this.m_nAddr);
    }

    public long getAddrLong() {
        return (long)this.m_nAddr & 0xFFFFFFFFL;
    }

    public int getMask() {
        return this.m_nMask;
    }

    public final long toLong() {
        return ((long)this.m_nAddr & 0xFFFFFFFFL) + ((long)this.m_nMask << 32);
    }

    public static final InetCidr fromLong(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("l must not be negative: " + l);
        }
        long l2 = l & 0xFFFFFFFFL;
        long l3 = l >> 32;
        return new InetCidr(Util.long2InetAddress(l2), (int)l3);
    }

    public int hashCode() {
        return this.m_nAddr ^ this.m_nMask;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof InetCidr)) {
            return false;
        }
        InetCidr inetCidr = (InetCidr)object;
        return this.m_nAddr == inetCidr.m_nAddr && this.m_nMask == inetCidr.m_nMask;
    }

    public static InetCidr[] addr2Cidr(InetAddress inetAddress) {
        if (inetAddress == null) {
            throw new IllegalArgumentException("addr must not be null");
        }
        if (!(inetAddress instanceof Inet4Address)) {
            throw new IllegalArgumentException("Only IPv4 addresses supported");
        }
        int n = Util.inetAddress2Int(inetAddress);
        InetCidr[] inetCidrArray = new InetCidr[32];
        for (int i = inetCidrArray.length; i >= 1; --i) {
            inetCidrArray[32 - i] = new InetCidr(Util.int2InetAddress(n & (int)CIDR_MASK_LONG[i]), i);
        }
        return inetCidrArray;
    }

    @Override
    public int compareTo(InetCidr inetCidr) {
        if (inetCidr == null) {
            throw new NullPointerException();
        }
        if (this.equals(inetCidr)) {
            return 0;
        }
        if (InetCidr._int2UnsignedLong(this.m_nAddr) < InetCidr._int2UnsignedLong(inetCidr.m_nAddr)) {
            return -1;
        }
        if (InetCidr._int2UnsignedLong(this.m_nAddr) > InetCidr._int2UnsignedLong(inetCidr.m_nAddr)) {
            return 1;
        }
        if (this.m_nMask < inetCidr.m_nMask) {
            return -1;
        }
        if (this.m_nMask > inetCidr.m_nMask) {
            return 1;
        }
        return 0;
    }

    private static final long _int2UnsignedLong(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    public static boolean isSorted(List<InetCidr> list) {
        if (list == null) {
            return true;
        }
        InetCidr inetCidr = null;
        for (InetCidr inetCidr2 : list) {
            if (inetCidr2 == null) {
                throw new NullPointerException();
            }
            if (inetCidr == null) {
                inetCidr = inetCidr2;
                continue;
            }
            if (inetCidr.compareTo(inetCidr2) >= 0) {
                return false;
            }
            inetCidr = inetCidr2;
        }
        return true;
    }

    public static void checkNoOverlap(List<InetCidr> list) {
        if (list == null) {
            return;
        }
        InetCidr inetCidr = null;
        long l = -1L;
        for (InetCidr inetCidr2 : list) {
            if (inetCidr2 == null) {
                throw new NullPointerException();
            }
            if (inetCidr != null && inetCidr2.getAddrLong() <= l) {
                throw new IllegalStateException("Overlapping cidr: " + inetCidr + ", " + inetCidr2);
            }
            l = inetCidr2.getAddrLong() + (CIDR_MASK_LONG[inetCidr2.getMask()] ^ 0xFFFFFFFFL);
            inetCidr = inetCidr2;
        }
    }

    static {
        try {
            InetCidr.CIDR_MASK_LONG[0] = 0L;
            for (int i = 0; i < CIDR_MASKS.length; ++i) {
                InetAddress inetAddress = InetAddress.getByName(CIDR_MASKS[i]);
                InetCidr.CIDR_MASK_LONG[i + 1] = Util.inetAddress2Long(inetAddress);
                CIDR.put(inetAddress, i + 1);
            }
        }
        catch (UnknownHostException unknownHostException) {
            throw new IllegalStateException("Unable to initialize CIDR");
        }
    }
}

