/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.schema;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.curator.framework.schema.DefaultSchemaValidator;
import org.apache.curator.framework.schema.Schema;
import org.apache.curator.framework.schema.SchemaValidator;

public class SchemaBuilder {
    private final Pattern pathRegex;
    private final String path;
    private String name = UUID.randomUUID().toString();
    private String documentation = "";
    private SchemaValidator schemaValidator = new DefaultSchemaValidator();
    private Schema.Allowance ephemeral = Schema.Allowance.CAN;
    private Schema.Allowance sequential = Schema.Allowance.CAN;
    private Schema.Allowance watched = Schema.Allowance.CAN;
    private boolean canBeDeleted = true;
    private Map<String, String> metadata = ImmutableMap.of();

    public Schema build() {
        return new Schema(this.name, this.pathRegex, this.path, this.documentation, this.schemaValidator, this.ephemeral, this.sequential, this.watched, this.canBeDeleted, this.metadata);
    }

    public SchemaBuilder name(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        return this;
    }

    public SchemaBuilder documentation(String documentation) {
        this.documentation = (String)Preconditions.checkNotNull((Object)documentation, (Object)"documentation cannot be null");
        return this;
    }

    public SchemaBuilder dataValidator(SchemaValidator schemaValidator) {
        this.schemaValidator = (SchemaValidator)Preconditions.checkNotNull((Object)schemaValidator, (Object)"dataValidator cannot be null");
        return this;
    }

    public SchemaBuilder ephemeral(Schema.Allowance ephemeral) {
        this.ephemeral = (Schema.Allowance)((Object)Preconditions.checkNotNull((Object)((Object)ephemeral), (Object)"ephemeral cannot be null"));
        return this;
    }

    public SchemaBuilder sequential(Schema.Allowance sequential) {
        this.sequential = (Schema.Allowance)((Object)Preconditions.checkNotNull((Object)((Object)sequential), (Object)"sequential cannot be null"));
        return this;
    }

    public SchemaBuilder watched(Schema.Allowance watched) {
        this.watched = watched;
        return this;
    }

    public SchemaBuilder canBeDeleted(boolean canBeDeleted) {
        this.canBeDeleted = canBeDeleted;
        return this;
    }

    public SchemaBuilder metadata(Map<String, String> metadata) {
        this.metadata = ImmutableMap.copyOf(metadata);
        return this;
    }

    SchemaBuilder(Pattern pathRegex, String path) {
        this.pathRegex = pathRegex;
        this.path = path;
    }
}

