/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.log.osgi;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.hawt.log.LogFilter;
import io.hawt.log.LogResults;
import io.hawt.log.osgi.LogQueryMBean;
import io.hawt.log.osgi.Logs;
import io.hawt.log.osgi.MavenCoordinates;
import io.hawt.log.support.LogQuerySupport;
import io.hawt.log.support.Predicate;
import java.io.IOException;
import org.apache.karaf.log.core.LogService;
import org.ops4j.pax.logging.spi.PaxLoggingEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogQuery
extends LogQuerySupport
implements LogQueryMBean {
    private transient Logger LOG = LoggerFactory.getLogger(LogQuery.class);
    private final LogService logService;

    public LogQuery(LogService logService) {
        this.logService = logService;
        this.mapper.getSerializationConfig().withPropertyInclusion(JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.NON_EMPTY, (JsonInclude.Include)JsonInclude.Include.ALWAYS));
    }

    @Override
    public String getBundleMavenCoordinates(long bundleId) {
        return MavenCoordinates.getMavenCoordinates(bundleId);
    }

    public LogResults getLogResults(int count) throws IOException {
        LogResults events = this.getLogEventList(count, null);
        return events;
    }

    public LogResults queryLogResults(LogFilter filter) {
        Predicate<PaxLoggingEvent> predicate = Logs.createPredicate(filter);
        int count = -1;
        if (filter != null) {
            count = filter.getCount();
        }
        return this.getLogEventList(count, predicate);
    }

    public LogResults getLogEventList(int count, Predicate<PaxLoggingEvent> predicate) {
        LogResults answer = new LogResults();
        answer.setHost(this.getHostName());
        long from = Long.MAX_VALUE;
        long to = Long.MIN_VALUE;
        if (this.logService != null) {
            Iterable iterable = this.logService.getEvents();
            if (iterable != null) {
                int matched = 0;
                for (PaxLoggingEvent event : iterable) {
                    if (event == null) continue;
                    long timestamp = event.getTimeStamp();
                    if (timestamp > to) {
                        to = timestamp;
                    }
                    if (timestamp < from) {
                        from = timestamp;
                    }
                    if (predicate != null && !predicate.matches((Object)event)) continue;
                    answer.addEvent(Logs.newInstance(event));
                    if (count <= 0 || ++matched < count) continue;
                    break;
                }
            }
        } else {
            this.LOG.warn("No Karaf LogService available!");
        }
        answer.setFromTimestamp(Long.valueOf(from));
        answer.setToTimestamp(Long.valueOf(to));
        return answer;
    }
}

