/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.health.api;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.opennms.core.health.api.HealthCheck;
import org.opennms.core.health.api.Response;
import org.opennms.core.health.api.Status;

public class Health {
    private final List<Pair<HealthCheck, Response>> responses;

    public Health() {
        this.responses = new ArrayList<Pair<HealthCheck, Response>>();
    }

    public Health(List<Pair<HealthCheck, Response>> responses) {
        this.responses = responses;
    }

    public Health withResponse(HealthCheck healthCheck, Response response) {
        this.add(healthCheck, response);
        return this;
    }

    public boolean isSuccess() {
        return this.responses.stream().allMatch(r -> ((Response)r.getRight()).getStatus() == Status.Success);
    }

    public Optional<Pair<HealthCheck, Response>> getWorst() {
        return this.responses.stream().max(Comparator.comparing(p -> ((Response)p.getRight()).getStatus()));
    }

    public void add(HealthCheck healthCheck, Response response) {
        this.responses.add((Pair<HealthCheck, Response>)Pair.of((Object)healthCheck, (Object)response));
    }

    public List<Pair<HealthCheck, Response>> getResponses() {
        return new ArrayList<Pair<HealthCheck, Response>>(this.responses);
    }
}

