/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.dhcp.client;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Collections;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.features.dhcpd.Dhcpd;
import org.opennms.features.dhcpd.Transaction;
import org.opennms.netmgt.provision.detector.dhcp.request.DhcpRequest;
import org.opennms.netmgt.provision.detector.dhcp.response.DhcpResponse;
import org.opennms.netmgt.provision.support.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DhcpClient
implements Client<DhcpRequest, DhcpResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(DhcpClient.class);
    private int retries;
    private int timeout;
    private InetAddress address;
    private final String macAddress;
    private final String myIpAddress;
    private final boolean extendedMode;
    private final boolean relayMode;
    private final String requestIpAddress;
    private Dhcpd dhcpd;

    public DhcpClient(String macAddress, boolean relayMode, String myIpAddress, boolean extendedMode, String requestIpAddress, int timeout, int retries, Dhcpd dhcpd) {
        this.macAddress = macAddress;
        this.relayMode = relayMode;
        this.myIpAddress = myIpAddress;
        this.extendedMode = extendedMode;
        this.requestIpAddress = requestIpAddress;
        this.timeout = timeout;
        this.retries = retries;
        this.dhcpd = dhcpd;
    }

    public void close() {
    }

    public void connect(InetAddress address, int port, int timeout) {
        this.address = address;
        this.timeout = timeout;
    }

    public DhcpResponse receiveBanner() {
        TimeoutTracker tracker = new TimeoutTracker(Collections.emptyMap(), this.retries, this.timeout);
        Transaction transaction = null;
        tracker.reset();
        while (tracker.shouldRetry() && (transaction == null || !transaction.isSuccess())) {
            try {
                LOG.error("Checking for Dhcp: {}", transaction);
                transaction = this.dhcpd.executeTransaction(this.address.getHostAddress(), this.macAddress, this.relayMode, this.myIpAddress, this.extendedMode, this.requestIpAddress, this.timeout);
            }
            catch (IOException e) {
                LOG.error("An unexpected exception occurred during DHCP detection", (Throwable)e);
                return new DhcpResponse(-1L);
            }
            tracker.nextAttempt();
        }
        if (transaction == null) {
            return new DhcpResponse(-1L);
        }
        return new DhcpResponse(transaction.getResponseTime());
    }

    public DhcpResponse sendRequest(DhcpRequest request) throws IOException, Exception {
        return null;
    }
}

