/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.table;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Comparator;
import org.iq80.leveldb.CompressionType;
import org.iq80.leveldb.table.Block;
import org.iq80.leveldb.table.BlockHandle;
import org.iq80.leveldb.table.BlockTrailer;
import org.iq80.leveldb.table.Footer;
import org.iq80.leveldb.table.Table;
import org.iq80.leveldb.util.Slice;
import org.iq80.leveldb.util.Slices;
import org.iq80.leveldb.util.Snappy;

public class FileChannelTable
extends Table {
    public FileChannelTable(String name, FileChannel fileChannel, Comparator<Slice> comparator, boolean verifyChecksums) throws IOException {
        super(name, fileChannel, comparator, verifyChecksums);
    }

    @Override
    protected Footer init() throws IOException {
        long size2 = this.fileChannel.size();
        ByteBuffer footerData = this.read(size2 - 48L, 48);
        return Footer.readFooter(Slices.copiedBuffer(footerData));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Block readBlock(BlockHandle blockHandle) throws IOException {
        Slice uncompressedData;
        ByteBuffer trailerData = this.read(blockHandle.getOffset() + (long)blockHandle.getDataSize(), 5);
        BlockTrailer blockTrailer = BlockTrailer.readBlockTrailer(Slices.copiedBuffer(trailerData));
        ByteBuffer uncompressedBuffer = this.read(blockHandle.getOffset(), blockHandle.getDataSize());
        if (blockTrailer.getCompressionType() == CompressionType.SNAPPY) {
            Class<FileChannelTable> clazz = FileChannelTable.class;
            synchronized (FileChannelTable.class) {
                int uncompressedLength = this.uncompressedLength(uncompressedBuffer);
                if (uncompressedScratch.capacity() < uncompressedLength) {
                    uncompressedScratch = ByteBuffer.allocateDirect(uncompressedLength);
                }
                uncompressedScratch.clear();
                Snappy.uncompress(uncompressedBuffer, uncompressedScratch);
                uncompressedData = Slices.copiedBuffer(uncompressedScratch);
                // ** MonitorExit[var6_5] (shouldn't be in output)
            }
        } else {
            uncompressedData = Slices.copiedBuffer(uncompressedBuffer);
        }
        return new Block(uncompressedData, this.comparator);
    }

    private ByteBuffer read(long offset, int length) throws IOException {
        ByteBuffer uncompressedBuffer = ByteBuffer.allocate(length);
        this.fileChannel.read(uncompressedBuffer, offset);
        if (uncompressedBuffer.hasRemaining()) {
            throw new IOException("Could not read all the data");
        }
        uncompressedBuffer.clear();
        return uncompressedBuffer;
    }
}

