/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mqtt.client;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.UTF8Buffer;
import org.fusesource.mqtt.client.Callback;
import org.fusesource.mqtt.client.Future;
import org.fusesource.mqtt.client.FutureConnection;
import org.fusesource.mqtt.client.Message;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.client.Topic;

public class BlockingConnection {
    private final FutureConnection next;

    public BlockingConnection(FutureConnection next) {
        this.next = next;
    }

    public boolean isConnected() {
        return this.next.isConnected();
    }

    public void connect() throws Exception {
        this.next.connect().await();
    }

    public void disconnect() throws Exception {
        this.next.disconnect().await();
    }

    public void kill() throws Exception {
        this.next.kill().await();
    }

    public byte[] subscribe(Topic[] topics) throws Exception {
        return this.next.subscribe(topics).await();
    }

    public void unsubscribe(String[] topics) throws Exception {
        this.next.unsubscribe(topics).await();
    }

    public void unsubscribe(UTF8Buffer[] topics) throws Exception {
        this.next.unsubscribe(topics).await();
    }

    public void publish(UTF8Buffer topic, Buffer payload, QoS qos, boolean retain2) throws Exception {
        this.next.publish(topic, payload, qos, retain2).await();
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void publish(String topic, byte[] payload, QoS qos, boolean retain2) throws Exception {
        this.publish(Buffer.utf8(topic), new Buffer(payload), qos, retain2);
    }

    public Message receive() throws Exception {
        return this.next.receive().await();
    }

    public Message receive(long amount, TimeUnit unit) throws Exception {
        Future<Message> receive = this.next.receive();
        try {
            Message message = receive.await(amount, unit);
            if (message != null) {
                message.blocking = true;
            }
            return message;
        }
        catch (TimeoutException e) {
            receive.then(new Callback<Message>(){

                @Override
                public void onSuccess(Message value) {
                    BlockingConnection.this.next.putBackMessage(value);
                }

                @Override
                public void onFailure(Throwable value) {
                }
            });
            return null;
        }
    }

    public void setReceiveBuffer(final long receiveBuffer) throws InterruptedException {
        final CountDownLatch done = new CountDownLatch(1);
        this.next.getDispatchQueue().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    BlockingConnection.this.next.setReceiveBuffer(receiveBuffer);
                }
                finally {
                    done.countDown();
                }
            }
        });
        done.await();
    }

    public long getReceiveBuffer() throws InterruptedException {
        final CountDownLatch done = new CountDownLatch(1);
        final AtomicLong result = new AtomicLong();
        this.next.getDispatchQueue().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    result.set(BlockingConnection.this.next.getReceiveBuffer());
                }
                finally {
                    done.countDown();
                }
            }
        });
        done.await();
        return result.get();
    }

    public void resume() {
        this.next.resume();
    }

    public void suspend() {
        this.next.suspend();
    }
}

