/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtbuf.proto;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.BufferInputStream;
import org.fusesource.hawtbuf.proto.InvalidProtocolBufferException;
import org.fusesource.hawtbuf.proto.WireFormat;

public final class CodedInputStream
extends FilterInputStream {
    private int lastTag = 0;
    private int limit = Integer.MAX_VALUE;
    private int pos;
    private BufferInputStream bis;

    public CodedInputStream(InputStream in) {
        super(in);
        if (in.getClass() == BufferInputStream.class) {
            this.bis = (BufferInputStream)in;
        }
    }

    public CodedInputStream(Buffer data) {
        this(new BufferInputStream(data));
        this.limit = data.length;
    }

    public CodedInputStream(byte[] data) {
        this(new BufferInputStream(data));
        this.limit = data.length;
    }

    public int readTag() throws IOException {
        if (this.pos >= this.limit) {
            this.lastTag = 0;
            return 0;
        }
        try {
            this.lastTag = this.readRawVarint32();
            if (this.lastTag == 0) {
                throw InvalidProtocolBufferException.invalidTag();
            }
            return this.lastTag;
        }
        catch (EOFException e) {
            this.lastTag = 0;
            return 0;
        }
    }

    public void checkLastTagWas(int value) throws InvalidProtocolBufferException {
        if (this.lastTag != value) {
            throw InvalidProtocolBufferException.invalidEndTag();
        }
    }

    public boolean skipField(int tag) throws IOException {
        switch (WireFormat.getTagWireType(tag)) {
            case 0: {
                this.readInt32();
                return true;
            }
            case 1: {
                this.readRawLittleEndian64();
                return true;
            }
            case 2: {
                this.skipRawBytes(this.readRawVarint32());
                return true;
            }
            case 3: {
                this.skipMessage();
                this.checkLastTagWas(WireFormat.makeTag(WireFormat.getTagFieldNumber(tag), 4));
                return true;
            }
            case 4: {
                return false;
            }
            case 5: {
                this.readRawLittleEndian32();
                return true;
            }
        }
        throw InvalidProtocolBufferException.invalidWireType();
    }

    public void skipMessage() throws IOException {
        int tag;
        while ((tag = this.readTag()) != 0 && this.skipField(tag)) {
        }
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readRawLittleEndian64());
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readRawLittleEndian32());
    }

    public long readUInt64() throws IOException {
        return this.readRawVarint64();
    }

    public long readInt64() throws IOException {
        return this.readRawVarint64();
    }

    public int readInt32() throws IOException {
        return this.readRawVarint32();
    }

    public long readFixed64() throws IOException {
        return this.readRawLittleEndian64();
    }

    public int readFixed32() throws IOException {
        return this.readRawLittleEndian32();
    }

    public boolean readBool() throws IOException {
        return this.readRawVarint32() != 0;
    }

    public String readString() throws IOException {
        int size2 = this.readRawVarint32();
        Buffer data = this.readRawBytes(size2);
        return new String(data.data, data.offset, data.length, "UTF-8");
    }

    public Buffer readBytes() throws IOException {
        int size2 = this.readRawVarint32();
        return this.readRawBytes(size2);
    }

    public int readUInt32() throws IOException {
        return this.readRawVarint32();
    }

    public int readEnum() throws IOException {
        return this.readRawVarint32();
    }

    public int readSFixed32() throws IOException {
        return this.readRawLittleEndian32();
    }

    public long readSFixed64() throws IOException {
        return this.readRawLittleEndian64();
    }

    public int readSInt32() throws IOException {
        return CodedInputStream.decodeZigZag32(this.readRawVarint32());
    }

    public long readSInt64() throws IOException {
        return CodedInputStream.decodeZigZag64(this.readRawVarint64());
    }

    public int readRawVarint32() throws IOException {
        byte tmp = this.readRawByte();
        if (tmp >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        tmp = this.readRawByte();
        if (tmp >= 0) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7F) << 7;
            tmp = this.readRawByte();
            if (tmp >= 0) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7F) << 14;
                tmp = this.readRawByte();
                if (tmp >= 0) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7F) << 21;
                    tmp = this.readRawByte();
                    result |= tmp << 28;
                    if (tmp < 0) {
                        for (int i = 0; i < 5; ++i) {
                            if (this.readRawByte() < 0) continue;
                            return result;
                        }
                        throw InvalidProtocolBufferException.malformedVarint();
                    }
                }
            }
        }
        return result;
    }

    public long readRawVarint64() throws IOException {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = this.readRawByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw InvalidProtocolBufferException.malformedVarint();
    }

    public int readRawLittleEndian32() throws IOException {
        byte b1 = this.readRawByte();
        byte b2 = this.readRawByte();
        byte b3 = this.readRawByte();
        byte b4 = this.readRawByte();
        return b1 & 0xFF | (b2 & 0xFF) << 8 | (b3 & 0xFF) << 16 | (b4 & 0xFF) << 24;
    }

    public long readRawLittleEndian64() throws IOException {
        byte b1 = this.readRawByte();
        byte b2 = this.readRawByte();
        byte b3 = this.readRawByte();
        byte b4 = this.readRawByte();
        byte b5 = this.readRawByte();
        byte b6 = this.readRawByte();
        byte b7 = this.readRawByte();
        byte b8 = this.readRawByte();
        return (long)b1 & 0xFFL | ((long)b2 & 0xFFL) << 8 | ((long)b3 & 0xFFL) << 16 | ((long)b4 & 0xFFL) << 24 | ((long)b5 & 0xFFL) << 32 | ((long)b6 & 0xFFL) << 40 | ((long)b7 & 0xFFL) << 48 | ((long)b8 & 0xFFL) << 56;
    }

    public static int decodeZigZag32(int n) {
        return n >>> 1 ^ -(n & 1);
    }

    public static long decodeZigZag64(long n) {
        return n >>> 1 ^ -(n & 1L);
    }

    public byte readRawByte() throws IOException {
        if (this.pos >= this.limit) {
            throw new EOFException();
        }
        int rc = this.in.read();
        if (rc < 0) {
            throw new EOFException();
        }
        ++this.pos;
        return (byte)(rc & 0xFF);
    }

    public Buffer readRawBytes(int size2) throws IOException {
        int c;
        if (size2 == 0) {
            return new Buffer(new byte[0]);
        }
        if (this.pos + size2 > this.limit) {
            throw new EOFException();
        }
        if (this.bis != null) {
            Buffer rc = this.bis.readBuffer(size2);
            if (rc == null || rc.getLength() < size2) {
                throw new EOFException();
            }
            this.pos += rc.getLength();
            return rc;
        }
        byte[] rc = new byte[size2];
        for (int pos = 0; pos < size2; pos += c) {
            c = this.in.read(rc, pos, size2 - pos);
            if (c < 0) {
                throw new EOFException();
            }
            this.pos += c;
        }
        return new Buffer(rc);
    }

    public void skipRawBytes(int size2) throws IOException {
        int n;
        for (int pos = 0; pos < size2; pos += n) {
            n = (int)this.in.skip(size2 - pos);
        }
    }

    public int pushLimit(int limit) {
        int rc = this.limit;
        this.limit = this.pos + limit;
        return rc;
    }

    public void popLimit(int limit) {
        this.limit = limit;
    }
}

