/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.health.shell;

import java.time.Duration;
import java.util.Arrays;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.core.health.api.Context;
import org.opennms.core.health.api.Health;
import org.opennms.core.health.api.HealthCheck;
import org.opennms.core.health.api.HealthCheckService;
import org.opennms.core.health.api.Response;
import org.opennms.core.health.api.Status;
import org.opennms.core.health.shell.Color;
import org.opennms.core.health.shell.Colorizer;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="opennms", name="health-check", description="Verifies that the container is healthy.")
@Service
public class HealthCheckCommand
implements Action {
    private static final Logger LOG = LoggerFactory.getLogger(HealthCheckCommand.class);
    public static final String SUCCESS_MESSAGE = "=> Everything is awesome";
    public static final String FAILURE_MESSAGE = "=> Oh no, something is wrong";
    private static final String DESCRIPTION_FORMAT = "%%-%ds   ";
    private static final String STATUS_FORMAT = "[ %%-%ds ]";
    @Option(name="-t", description="Maximum number of milliseconds to wait before failing when waiting for a check to complete (e.g. try to establish a JMS session.")
    public long timeout = 5000L;
    @Option(name="--maxAge", description="Maximum age of cached health check responses in milliseconds. Defaults to 90,000.")
    public long maxAgeMs = 90000L;
    @Reference
    private BundleContext bundleContext;
    @Reference
    private HealthCheckService healthCheckService;

    public static boolean isEndMessage(String s) {
        return s.startsWith(SUCCESS_MESSAGE) || s.startsWith(FAILURE_MESSAGE);
    }

    public Object execute() throws Exception {
        System.out.println("Verifying the health of the container");
        System.out.println();
        LOG.debug("Verifying the health of the container");
        Context context = new Context();
        context.setTimeout(this.timeout);
        context.setMaxAge(Duration.ofMillis(this.maxAgeMs));
        Listener listener = new Listener();
        this.healthCheckService.performAsyncHealthCheck(context, (HealthCheckService.ProgressListener)listener, null).fold(errorMessage -> {
            System.out.println(Colorizer.colorize("Error: " + errorMessage, Color.Red));
            System.out.println(FAILURE_MESSAGE);
            LOG.debug("Error: {}", errorMessage);
            LOG.debug("Oh no, something is wrong");
            return null;
        }, completionStage -> {
            String next;
            while ((next = listener.read()) != null) {
                System.out.print(next);
                System.out.flush();
                LOG.debug(next);
            }
            return null;
        });
        return null;
    }

    private static Color determineColor(Status status) {
        switch (status) {
            case Failure: {
                return Color.Red;
            }
            case Timeout: {
                return Color.Yellow;
            }
            case Starting: {
                return Color.Blue;
            }
            case Success: {
                return Color.Green;
            }
            case Unknown: {
                return Color.Yellow;
            }
        }
        return Color.NoColor;
    }

    private static class Listener
    implements HealthCheckService.ProgressListener {
        private List<HealthCheck> checks;
        private String descFormat;
        private String statusFormat;
        private final Map<HealthCheck, Response> responses = new IdentityHashMap<HealthCheck, Response>();
        private final BlockingQueue<String> out = new LinkedBlockingQueue<String>();
        private boolean completed = false;

        private Listener() {
        }

        private void print(String string) {
            this.out.add(string);
        }

        private void println() {
            this.print("\n");
        }

        private void println(String string) {
            this.print(string + "\n");
        }

        public synchronized void onHealthChecksFound(List<HealthCheck> healthChecks) {
            this.checks = healthChecks;
            int maxColorLength = Arrays.stream(Color.values()).map(c -> c.toAnsi()).max(Comparator.comparingInt(String::length)).get().length();
            int maxDescriptionLength = healthChecks.stream().map(check -> check.getDescription()).max(Comparator.comparingInt(String::length)).orElse("").length();
            int maxStatusLength = Arrays.stream(Status.values()).map(v -> v.name()).max(Comparator.comparingInt(String::length)).get().length() + maxColorLength + "\u001b[m".length() * 2 + Color.NoColor.toAnsi().length();
            this.descFormat = String.format(HealthCheckCommand.DESCRIPTION_FORMAT, maxDescriptionLength);
            this.statusFormat = String.format(HealthCheckCommand.STATUS_FORMAT, maxStatusLength);
            this.printCurrentExecutionState();
        }

        public synchronized void onResponse(HealthCheck check, Response response) {
            this.responses.put(check, response);
            this.print(String.format("\u001b[%dA", this.checks.size()));
            this.printCurrentExecutionState();
        }

        public synchronized void onAllHealthChecksCompleted(Health health) {
            this.println();
            if (health.isSuccess()) {
                this.println(HealthCheckCommand.SUCCESS_MESSAGE);
            } else {
                this.println(HealthCheckCommand.FAILURE_MESSAGE);
            }
        }

        private void printCurrentExecutionState() {
            for (HealthCheck healthCheck : this.checks) {
                Object str = String.format(this.descFormat, healthCheck.getDescription());
                Response response = this.responses.get(healthCheck);
                if (response != null) {
                    Status status = response.getStatus();
                    Color statusColor = HealthCheckCommand.determineColor(status);
                    String statusText = String.format(this.statusFormat, Colorizer.colorize(status.name(), statusColor));
                    str = (String)str + statusText;
                    if (response.getMessage() != null) {
                        str = (String)str + " => " + response.getMessage();
                    }
                } else {
                    str = (String)str + "[ ]";
                }
                this.println((String)str);
            }
        }

        public String read() {
            if (this.completed) {
                return null;
            }
            try {
                String string = this.out.take();
                this.completed = HealthCheckCommand.isEndMessage(string);
                return string;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

