/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp.message;

import java.nio.ByteBuffer;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.WritableBuffer;

public class AmqpWritableBuffer
implements WritableBuffer {
    public static final int DEFAULT_CAPACITY = 4096;
    byte[] buffer;
    int position;

    public AmqpWritableBuffer() {
        this(4096);
    }

    public AmqpWritableBuffer(int capacity) {
        this.buffer = new byte[capacity];
    }

    public byte[] getArray() {
        return this.buffer;
    }

    public int getArrayLength() {
        return this.position;
    }

    @Override
    public void put(byte b) {
        int newPosition = this.position + 1;
        this.ensureCapacity(newPosition);
        this.buffer[this.position] = b;
        this.position = newPosition;
    }

    @Override
    public void putShort(short value) {
        this.ensureCapacity(this.position + 2);
        this.buffer[this.position++] = (byte)(value >>> 8);
        this.buffer[this.position++] = (byte)(value >>> 0);
    }

    @Override
    public void putInt(int value) {
        this.ensureCapacity(this.position + 4);
        this.buffer[this.position++] = (byte)(value >>> 24);
        this.buffer[this.position++] = (byte)(value >>> 16);
        this.buffer[this.position++] = (byte)(value >>> 8);
        this.buffer[this.position++] = (byte)(value >>> 0);
    }

    @Override
    public void putLong(long value) {
        this.ensureCapacity(this.position + 8);
        this.buffer[this.position++] = (byte)(value >>> 56);
        this.buffer[this.position++] = (byte)(value >>> 48);
        this.buffer[this.position++] = (byte)(value >>> 40);
        this.buffer[this.position++] = (byte)(value >>> 32);
        this.buffer[this.position++] = (byte)(value >>> 24);
        this.buffer[this.position++] = (byte)(value >>> 16);
        this.buffer[this.position++] = (byte)(value >>> 8);
        this.buffer[this.position++] = (byte)(value >>> 0);
    }

    @Override
    public void putFloat(float value) {
        this.putInt(Float.floatToRawIntBits(value));
    }

    @Override
    public void putDouble(double value) {
        this.putLong(Double.doubleToRawLongBits(value));
    }

    @Override
    public void put(byte[] src, int offset, int length) {
        if (length == 0) {
            return;
        }
        int newPosition = this.position + length;
        this.ensureCapacity(newPosition);
        System.arraycopy(src, offset, this.buffer, this.position, length);
        this.position = newPosition;
    }

    @Override
    public boolean hasRemaining() {
        return this.position < Integer.MAX_VALUE;
    }

    @Override
    public int remaining() {
        return Integer.MAX_VALUE - this.position;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public void position(int position) {
        this.ensureCapacity(position);
        this.position = position;
    }

    @Override
    public void put(ByteBuffer payload) {
        int newPosition = this.position + payload.remaining();
        this.ensureCapacity(newPosition);
        while (payload.hasRemaining()) {
            this.buffer[this.position++] = payload.get();
        }
        this.position = newPosition;
    }

    @Override
    public int limit() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void put(ReadableBuffer src) {
        this.ensureCapacity(this.position);
        src.get(this);
    }

    private void ensureCapacity(int minimumCapacity) {
        if (minimumCapacity > this.buffer.length) {
            byte[] newBuffer = new byte[Math.max(this.buffer.length << 1, minimumCapacity)];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.position);
            this.buffer = newBuffer;
        }
    }
}

