/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.rpc.camel;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.opennms.core.rpc.api.RpcModule;
import org.opennms.core.rpc.api.RpcRequest;
import org.opennms.core.rpc.api.RpcResponse;
import org.opennms.distributed.core.api.MinionIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CamelRpcServerRouteManager {
    private static final Logger LOG = LoggerFactory.getLogger(CamelRpcServerRouteManager.class);
    private final CamelContext context;
    private final MinionIdentity identity;
    private final Map<RpcModule<RpcRequest, RpcResponse>, String> routeIdsByModule = new ConcurrentHashMap<RpcModule<RpcRequest, RpcResponse>, String>();

    public CamelRpcServerRouteManager(CamelContext context, MinionIdentity identity) {
        this.context = Objects.requireNonNull(context);
        this.identity = Objects.requireNonNull(identity);
    }

    public static String getRouteId(RpcModule<?, ?> module) {
        return "RPC.Server." + module.getId();
    }

    public abstract RouteBuilder getRouteBuilder(CamelContext var1, MinionIdentity var2, RpcModule<RpcRequest, RpcResponse> var3);

    public void bind(RpcModule module) throws Exception {
        if (module != null) {
            RpcModule rpcModule = module;
            String routeId = CamelRpcServerRouteManager.getRouteId(rpcModule);
            Route existingRoute = this.context.getRoute(routeId);
            if (this.routeIdsByModule.containsKey(rpcModule)) {
                if (existingRoute == null) {
                    LOG.error("RpcModule {} ({}) was marked as registered but its route {} cannot be found in the Camel context", new Object[]{rpcModule.getId(), Integer.toHexString(rpcModule.hashCode()), routeId});
                } else {
                    LOG.warn("RpcModule {} ({}) was already registered on route {}: {}", new Object[]{rpcModule.getId(), Integer.toHexString(rpcModule.hashCode()), routeId, existingRoute});
                }
            } else if (existingRoute == null) {
                RouteBuilder routeBuilder = this.getRouteBuilder(this.context, this.identity, (RpcModule<RpcRequest, RpcResponse>)module);
                this.context.addRoutes((RoutesBuilder)routeBuilder);
                this.routeIdsByModule.put((RpcModule<RpcRequest, RpcResponse>)rpcModule, routeId);
                LOG.info("Registered RpcModule {} ({}) on route {} with builder {}", new Object[]{rpcModule.getId(), Integer.toHexString(rpcModule.hashCode()), routeId, routeBuilder});
            } else {
                LOG.warn("RpcModule {} ({}) cannot be registered, route {} is already present: {}", new Object[]{rpcModule.getId(), Integer.toHexString(rpcModule.hashCode()), routeId, existingRoute});
            }
        }
    }

    public void unbind(RpcModule module) throws Exception {
        if (module != null) {
            RpcModule rpcModule = module;
            String routeId = this.routeIdsByModule.remove(rpcModule);
            if (routeId != null) {
                this.context.stopRoute(routeId);
                this.context.removeRoute(routeId);
                LOG.info("Deregistered RpcModule {} ({})", (Object)rpcModule.getId(), (Object)Integer.toHexString(rpcModule.hashCode()));
            } else {
                LOG.warn("Could not determine route ID for RpcModule {} ({})", (Object)rpcModule.getId(), (Object)Integer.toHexString(rpcModule.hashCode()));
            }
        }
    }
}

