/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.minion.dominion.grpc;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.opennms.dominion.local.rpc.grpc.DominionGrpc;
import org.opennms.dominion.local.rpc.grpc.SecureCredentialsVaultGrpc;

public class DominionScvGrpcClient {
    private final String clientId;
    private final String clientSecret;
    private final SecureCredentialsVaultGrpc.SecureCredentialsVaultBlockingStub clientStub;

    public DominionScvGrpcClient(String clientId, String clientSecret, ManagedChannel channel) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.clientStub = SecureCredentialsVaultGrpc.newBlockingStub((Channel)channel);
    }

    public DominionGrpc.ScvSupportedAliasesResponse getAliases() {
        DominionGrpc.ScvSupportedAliasesRequest request = DominionGrpc.ScvSupportedAliasesRequest.newBuilder().setClientCredentials(DominionGrpc.ClientCredentials.newBuilder().setClientId(this.clientId).setClientSecret(this.clientSecret).build()).build();
        return this.clientStub.scvGetSupportedAliases(request);
    }

    public DominionGrpc.ScvGetCredentialsResponse getCredentials(String alias) {
        Objects.requireNonNull(alias);
        DominionGrpc.ScvGetCredentialsRequest request = DominionGrpc.ScvGetCredentialsRequest.newBuilder().setClientCredentials(DominionGrpc.ClientCredentials.newBuilder().setClientId(this.clientId).setClientSecret(this.clientSecret).build()).setAlias(alias).build();
        return this.clientStub.scvGetCredentials(request);
    }

    public DominionGrpc.ScvSetCredentialsResponse setCredentials(String alias, String username, String password, Map<String, String> attributes) {
        Objects.requireNonNull(alias);
        Objects.requireNonNull(username);
        Objects.requireNonNull(password);
        DominionGrpc.ScvSetCredentialsRequest request = DominionGrpc.ScvSetCredentialsRequest.newBuilder().setClientCredentials(DominionGrpc.ClientCredentials.newBuilder().setClientId(this.clientId).setClientSecret(this.clientSecret).build()).setAlias(alias).setUser(username).setPassword(password).putAllAttributes(attributes != null ? attributes : Collections.emptyMap()).build();
        return this.clientStub.scvSetCredentials(request);
    }
}

