/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.minion.dominion.grpc;

import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.Objects;
import org.opennms.distributed.core.api.MinionIdentity;
import org.opennms.features.minion.dominion.grpc.DominionGrpcFactory;
import org.opennms.features.minion.dominion.grpc.DominionScvGrpcClient;

public class DominionGrpcFactoryImpl
implements DominionGrpcFactory {
    private final ManagedChannel channel;
    private final String clientId;
    private final String clientSecret;

    public DominionGrpcFactoryImpl(String host, String port, String clientSecret, MinionIdentity minionIdentity) {
        this(host, port, Objects.requireNonNull(minionIdentity).getId(), clientSecret);
    }

    public DominionGrpcFactoryImpl(String host, String port, String clientId, String clientSecret) {
        Objects.requireNonNull(host);
        Objects.requireNonNull(port);
        Objects.requireNonNull(clientId);
        Objects.requireNonNull(clientSecret);
        if (clientSecret.isEmpty()) {
            throw new IllegalArgumentException("The client secret cannot be empty");
        }
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.channel = ManagedChannelBuilder.forAddress((String)host, (int)Integer.parseInt(port)).usePlaintext().build();
    }

    public void destroy() {
        this.channel.shutdown();
    }

    @Override
    public DominionScvGrpcClient scvClient() {
        return new DominionScvGrpcClient(this.clientId, this.clientSecret, this.channel);
    }
}

