/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.service;

import java.io.Serializable;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.service.Value;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="attribute")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="service-configuration.xsd")
public class Attribute
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlElement(name="name")
    private String m_name;
    @XmlElement(name="value")
    private Value m_value;

    public Attribute() {
    }

    public Attribute(String name, String type, String content) {
        this.setName(name);
        this.setValue(new Value(type, content));
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = ConfigUtils.assertNotEmpty(name, "name");
    }

    public Value getValue() {
        return this.m_value;
    }

    public void setValue(Value value) {
        this.m_value = ConfigUtils.assertNotNull(value, "value");
    }

    public int hashCode() {
        return Objects.hash(this.m_name, this.m_value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Attribute) {
            Attribute that = (Attribute)obj;
            return Objects.equals(this.m_name, that.m_name) && Objects.equals(this.m_value, that.m_value);
        }
        return false;
    }
}

