/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.mailtransporttest;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.mailtransporttest.JavamailProperty;
import org.opennms.netmgt.config.mailtransporttest.ReadmailHost;
import org.opennms.netmgt.config.mailtransporttest.UserAuth;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="readmail-test")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="mail-transport-test.xsd")
public class ReadmailTest
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="debug")
    private Boolean m_debug;
    @XmlAttribute(name="mail-folder")
    private String m_mailFolder;
    @XmlAttribute(name="subject-match")
    private String m_subjectMatch;
    @XmlAttribute(name="attempt-interval")
    private Long m_attemptInterval;
    @XmlAttribute(name="delete-all-mail")
    private Boolean m_deleteAllMail;
    @XmlElement(name="javamail-property")
    private List<JavamailProperty> m_javamailProperties = new ArrayList<JavamailProperty>();
    @XmlElement(name="readmail-host", required=true)
    private ReadmailHost m_readmailHost;
    @XmlElement(name="user-auth")
    private UserAuth m_userAuth;

    public ReadmailTest() {
    }

    public ReadmailTest(Long attemptInterval, Boolean debug, String mailFolder, String subjectMatch, Boolean deleteAllMail) {
        this.setAttemptInterval(attemptInterval);
        this.setDebug(debug);
        this.setMailFolder(mailFolder);
        this.setSubjectMatch(subjectMatch);
        this.setDeleteAllMail(deleteAllMail);
    }

    public Boolean getDebug() {
        return this.m_debug == null ? Boolean.TRUE : this.m_debug;
    }

    public void setDebug(Boolean debug) {
        this.m_debug = debug;
    }

    public String getMailFolder() {
        return this.m_mailFolder == null ? "INBOX" : this.m_mailFolder;
    }

    public void setMailFolder(String mailFolder) {
        this.m_mailFolder = ConfigUtils.normalizeString(mailFolder);
    }

    public String getSubjectMatch() {
        return this.m_subjectMatch;
    }

    public void setSubjectMatch(String subjectMatch) {
        this.m_subjectMatch = ConfigUtils.normalizeString(subjectMatch);
    }

    public Long getAttemptInterval() {
        return this.m_attemptInterval == null ? 1000L : this.m_attemptInterval;
    }

    public void setAttemptInterval(Long attemptInterval) {
        this.m_attemptInterval = attemptInterval;
    }

    public Boolean getDeleteAllMail() {
        return this.m_deleteAllMail == null ? Boolean.FALSE : this.m_deleteAllMail;
    }

    public void setDeleteAllMail(Boolean deleteAllMail) {
        this.m_deleteAllMail = deleteAllMail;
    }

    public List<JavamailProperty> getJavamailProperties() {
        return this.m_javamailProperties;
    }

    public void setJavamailProperties(List<JavamailProperty> javamailProperties) {
        if (javamailProperties == this.m_javamailProperties) {
            return;
        }
        this.m_javamailProperties.clear();
        if (javamailProperties != null) {
            this.m_javamailProperties.addAll(javamailProperties);
        }
    }

    public void addJavamailProperty(JavamailProperty javamailProperty) {
        this.m_javamailProperties.add(javamailProperty);
    }

    public void addJavamailProperty(String name, String value) {
        this.m_javamailProperties.add(new JavamailProperty(name, value));
    }

    public ReadmailHost getReadmailHost() {
        return this.m_readmailHost;
    }

    public void setReadmailHost(ReadmailHost readmailHost) {
        this.m_readmailHost = ConfigUtils.assertNotEmpty(readmailHost, "readmail-host");
    }

    public Optional<UserAuth> getUserAuth() {
        return Optional.ofNullable(this.m_userAuth);
    }

    public void setUserAuth(UserAuth userAuth) {
        this.m_userAuth = userAuth;
    }

    public int hashCode() {
        return Objects.hash(this.m_debug, this.m_mailFolder, this.m_subjectMatch, this.m_attemptInterval, this.m_deleteAllMail, this.m_javamailProperties, this.m_readmailHost, this.m_userAuth);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ReadmailTest) {
            ReadmailTest that = (ReadmailTest)obj;
            return Objects.equals(this.m_debug, that.m_debug) && Objects.equals(this.m_mailFolder, that.m_mailFolder) && Objects.equals(this.m_subjectMatch, that.m_subjectMatch) && Objects.equals(this.m_attemptInterval, that.m_attemptInterval) && Objects.equals(this.m_deleteAllMail, that.m_deleteAllMail) && Objects.equals(this.m_javamailProperties, that.m_javamailProperties) && Objects.equals(this.m_readmailHost, that.m_readmailHost) && Objects.equals(this.m_userAuth, that.m_userAuth);
        }
        return false;
    }

    public void setUserAuth(String username, String password) {
        this.m_userAuth = new UserAuth(username, password);
    }
}

