/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.discovery;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.core.xml.DoubleAdapter;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.discovery.Definition;
import org.opennms.netmgt.config.discovery.ExcludeRange;
import org.opennms.netmgt.config.discovery.ExcludeUrl;
import org.opennms.netmgt.config.discovery.IncludeRange;
import org.opennms.netmgt.config.discovery.IncludeUrl;
import org.opennms.netmgt.config.discovery.Specific;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="discovery-configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="discovery-configuration.xsd")
public class DiscoveryConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute(name="location")
    private String location;
    @XmlAttribute(name="packets-per-second", required=true)
    @XmlJavaTypeAdapter(value=DoubleAdapter.class)
    private Double packetsPerSecond;
    @XmlAttribute(name="initial-sleep-time", required=true)
    private Long initialSleepTime;
    @XmlAttribute(name="restart-sleep-time", required=true)
    private Long restartSleepTime;
    @XmlAttribute(name="retries")
    private Integer retries;
    @XmlAttribute(name="timeout")
    private Long timeout;
    @XmlAttribute(name="foreign-source")
    private String foreignSource;
    @XmlAttribute(name="chunk-size")
    private Integer chunkSize;
    @XmlElement(name="specific")
    @JsonProperty(value="specific")
    private List<Specific> specifics = new ArrayList<Specific>();
    @XmlElement(name="include-range")
    @JsonProperty(value="include-range")
    private List<IncludeRange> includeRanges = new ArrayList<IncludeRange>();
    @XmlElement(name="exclude-range")
    @JsonProperty(value="exclude-range")
    private List<ExcludeRange> excludeRanges = new ArrayList<ExcludeRange>();
    @XmlElement(name="include-url")
    @JsonProperty(value="include-url")
    private List<IncludeUrl> includeUrls = new ArrayList<IncludeUrl>();
    @XmlElement(name="exclude-url")
    private List<ExcludeUrl> excludeUrls = new ArrayList<ExcludeUrl>();
    @XmlElement(name="definition")
    @JsonProperty(value="definition")
    private List<Definition> definitions = new ArrayList<Definition>();

    public Optional<String> getLocation() {
        return Optional.ofNullable(this.location);
    }

    public void setLocation(String location) {
        this.location = ConfigUtils.normalizeString(location);
    }

    public Optional<Double> getPacketsPerSecond() {
        return Optional.ofNullable(this.packetsPerSecond);
    }

    public void setPacketsPerSecond(Double packetsPerSecond) {
        this.packetsPerSecond = packetsPerSecond;
    }

    public Optional<Long> getInitialSleepTime() {
        return Optional.ofNullable(this.initialSleepTime);
    }

    public void setInitialSleepTime(Long initialSleepTime) {
        this.initialSleepTime = initialSleepTime;
    }

    public Optional<Long> getRestartSleepTime() {
        return Optional.ofNullable(this.restartSleepTime);
    }

    public void setRestartSleepTime(Long restartSleepTime) {
        this.restartSleepTime = restartSleepTime;
    }

    public Optional<Integer> getRetries() {
        return Optional.ofNullable(this.retries);
    }

    public void setRetries(Integer retries) {
        this.retries = retries;
    }

    public Optional<Long> getTimeout() {
        return Optional.ofNullable(this.timeout);
    }

    public void setTimeout(Long timeout) {
        if (timeout != null && timeout == 0L) {
            throw new IllegalArgumentException("Can't have a 0 timeout!");
        }
        this.timeout = timeout;
    }

    public Optional<String> getForeignSource() {
        return Optional.ofNullable(this.foreignSource);
    }

    public void setForeignSource(String foreignSource) {
        this.foreignSource = ConfigUtils.normalizeString(foreignSource);
    }

    public Optional<Integer> getChunkSize() {
        return Optional.ofNullable(this.chunkSize);
    }

    public void setChunkSize(Integer chunkSize) {
        this.chunkSize = chunkSize;
    }

    public List<Specific> getSpecifics() {
        return this.specifics;
    }

    public void setSpecifics(List<Specific> specifics) {
        if (specifics != null && specifics.equals(this.specifics)) {
            return;
        }
        this.specifics.clear();
        if (specifics != null) {
            this.specifics.addAll(specifics);
        }
    }

    public void addSpecific(Specific specific) {
        this.specifics.add(specific);
    }

    public boolean removeSpecific(Specific specific) {
        return this.specifics.remove(specific);
    }

    public void clearSpecifics() {
        this.specifics.clear();
    }

    public List<IncludeRange> getIncludeRanges() {
        return this.includeRanges;
    }

    public void setIncludeRanges(List<IncludeRange> includeRanges) {
        if (includeRanges != null && includeRanges.equals(this.includeRanges)) {
            return;
        }
        this.includeRanges.clear();
        if (includeRanges != null) {
            this.includeRanges.addAll(includeRanges);
        }
    }

    public void addIncludeRange(IncludeRange includeRange) {
        this.includeRanges.add(includeRange);
    }

    public boolean removeIncludeRange(IncludeRange includeRange) {
        return this.includeRanges.remove(includeRange);
    }

    public void clearIncludeRanges() {
        this.includeRanges.clear();
    }

    public List<ExcludeRange> getExcludeRanges() {
        return this.excludeRanges;
    }

    public void setExcludeRanges(List<ExcludeRange> excludeRanges) {
        if (excludeRanges != null && excludeRanges.equals(this.excludeRanges)) {
            return;
        }
        this.excludeRanges.clear();
        if (excludeRanges != null) {
            this.excludeRanges.addAll(excludeRanges);
        }
    }

    public void addExcludeRange(ExcludeRange excludeRange) {
        this.excludeRanges.add(excludeRange);
    }

    public boolean removeExcludeRange(ExcludeRange excludeRange) {
        return this.excludeRanges.remove(excludeRange);
    }

    public void clearExcludeRanges() {
        this.excludeRanges.clear();
    }

    public List<IncludeUrl> getIncludeUrls() {
        return this.includeUrls;
    }

    public void setIncludeUrls(List<IncludeUrl> includeUrls) {
        if (includeUrls != null && includeUrls.equals(this.includeUrls)) {
            return;
        }
        this.includeUrls.clear();
        if (includeUrls != null) {
            this.includeUrls.addAll(includeUrls);
        }
    }

    public void addIncludeUrl(IncludeUrl includeUrl) {
        this.includeUrls.add(includeUrl);
    }

    public boolean removeIncludeUrl(IncludeUrl includeUrl) {
        return this.includeUrls.remove(includeUrl);
    }

    public void clearIncludeUrls() {
        this.includeUrls.clear();
    }

    public List<ExcludeUrl> getExcludeUrls() {
        return this.excludeUrls;
    }

    public void setExcludeUrls(List<ExcludeUrl> excludeUrls) {
        if (excludeUrls != null && excludeUrls.equals(this.excludeUrls)) {
            return;
        }
        this.excludeUrls.clear();
        if (excludeUrls != null) {
            this.excludeUrls.addAll(excludeUrls);
        }
    }

    public void addExcludeUrl(ExcludeUrl excludeUrl) {
        this.excludeUrls.add(excludeUrl);
    }

    public boolean removeExcludeUrl(ExcludeUrl excludeUrl) {
        return this.excludeUrls.remove(excludeUrl);
    }

    public void clearExcludeUrls() {
        this.excludeUrls.clear();
    }

    public List<Definition> getDefinitions() {
        return this.definitions;
    }

    public void setDefinitions(List<Definition> definitions) {
        this.definitions = definitions;
    }

    public void addDefinition(Definition definition) {
        this.definitions.add(definition);
    }

    public int hashCode() {
        return Objects.hash(this.location, this.packetsPerSecond, this.initialSleepTime, this.restartSleepTime, this.retries, this.timeout, this.foreignSource, this.chunkSize, this.specifics, this.includeRanges, this.excludeRanges, this.includeUrls, this.excludeUrls);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DiscoveryConfiguration) {
            DiscoveryConfiguration that = (DiscoveryConfiguration)obj;
            return Objects.equals(this.location, that.location) && Objects.equals(this.packetsPerSecond, that.packetsPerSecond) && Objects.equals(this.initialSleepTime, that.initialSleepTime) && Objects.equals(this.restartSleepTime, that.restartSleepTime) && Objects.equals(this.retries, that.retries) && Objects.equals(this.timeout, that.timeout) && Objects.equals(this.foreignSource, that.foreignSource) && Objects.equals(this.chunkSize, that.chunkSize) && Objects.equals(this.specifics, that.specifics) && Objects.equals(this.includeRanges, that.includeRanges) && Objects.equals(this.excludeRanges, that.excludeRanges) && Objects.equals(this.includeUrls, that.includeUrls) && Objects.equals(this.excludeUrls, that.excludeUrls);
        }
        return false;
    }

    public String toString() {
        return "DiscoveryConfiguration [location=" + this.location + ", packetsPerSecond=" + this.packetsPerSecond + ", initialSleepTime=" + this.initialSleepTime + ", restartSleepTime=" + this.restartSleepTime + ", retries=" + this.retries + ", timeout=" + this.timeout + ", foreignSource=" + this.foreignSource + ", chunkSize=" + this.chunkSize + ", specifics=" + String.valueOf(this.specifics) + ", includeRanges=" + String.valueOf(this.includeRanges) + ", excludeRanges=" + String.valueOf(this.excludeRanges) + ", includeUrls=" + String.valueOf(this.includeUrls) + ", excludeUrls=" + String.valueOf(this.excludeUrls) + "]";
    }
}

