/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.distributed.kvstore.api;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.opennms.features.distributed.kvstore.api.AbstractKeyValueStore;

public abstract class AbstractAsyncKeyValueStore<T>
extends AbstractKeyValueStore<T> {
    private final Executor executor;

    protected AbstractAsyncKeyValueStore(Executor executor) {
        this.executor = Objects.requireNonNull(executor);
    }

    protected AbstractAsyncKeyValueStore() {
        this(new ThreadPoolExecutor(1, Runtime.getRuntime().availableProcessors() * 10, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("kvstore-async-thread-%d").build(), new ThreadPoolExecutor.CallerRunsPolicy()));
    }

    @Override
    public final CompletableFuture<Long> putAsync(String key, T value, String context, Integer ttlInSeconds) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        Objects.requireNonNull(context);
        return CompletableFuture.supplyAsync(() -> this.put(key, value, context, ttlInSeconds), this.executor);
    }

    @Override
    public final CompletableFuture<Optional<T>> getAsync(String key, String context) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(context);
        return CompletableFuture.supplyAsync(() -> this.get(key, context), this.executor);
    }

    @Override
    public final CompletableFuture<Optional<Optional<T>>> getIfStaleAsync(String key, String context, long timestamp) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(context);
        return CompletableFuture.supplyAsync(() -> this.getIfStale(key, context, timestamp));
    }

    @Override
    public final CompletableFuture<OptionalLong> getLastUpdatedAsync(String key, String context) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(context);
        return CompletableFuture.supplyAsync(() -> this.getLastUpdated(key, context), this.executor);
    }

    @Override
    public CompletableFuture<Map<String, T>> enumerateContextAsync(String context) {
        Objects.requireNonNull(context);
        return CompletableFuture.supplyAsync(() -> this.enumerateContext(context), this.executor);
    }

    @Override
    public CompletableFuture<Void> deleteAsync(String key, String context) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(context);
        return CompletableFuture.supplyAsync(() -> {
            this.delete(key, context);
            return null;
        }, this.executor);
    }

    @Override
    public CompletableFuture<Void> truncateContextAsync(String context) {
        Objects.requireNonNull(context);
        return CompletableFuture.supplyAsync(() -> {
            this.truncateContext(context);
            return null;
        }, this.executor);
    }
}

