/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.commands;

import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import org.apache.camel.commands.AbstractContextCommand;
import org.apache.camel.commands.CamelController;
import org.apache.camel.util.JsonSchemaHelper;

public class EipExplainCommand
extends AbstractContextCommand {
    private String nameOrId;
    private boolean verbose;

    public EipExplainCommand(String name, String nameOrId, boolean verbose) {
        super(name);
        this.verbose = verbose;
        this.nameOrId = nameOrId;
    }

    @Override
    protected Object performContextCommand(CamelController camelController, String contextName, PrintStream out, PrintStream err) throws Exception {
        String json = camelController.explainEipAsJSon(this.context, this.nameOrId, this.verbose);
        if (json == null) {
            return null;
        }
        out.println("Context:       " + this.context);
        List options = JsonSchemaHelper.parseJsonSchema((String)"properties", (String)json, (boolean)true);
        for (Map option : options) {
            String description;
            String defaultValue;
            String value;
            String javaType;
            String type;
            out.print("Option:        ");
            out.println((String)option.get("name"));
            String kind = (String)option.get("kind");
            if (kind != null) {
                out.print("Kind:          ");
                out.println(kind);
            }
            if ((type = (String)option.get("type")) != null) {
                out.print("Type:          ");
                out.println(type);
            }
            if ((javaType = (String)option.get("javaType")) != null) {
                out.print("Java Type:     ");
                out.println(javaType);
            }
            if ((value = (String)option.get("value")) != null) {
                out.print("Value:         ");
                out.println(value);
            }
            if ((defaultValue = (String)option.get("defaultValue")) != null) {
                out.print("Default Value: ");
                out.println(defaultValue);
            }
            if ((description = (String)option.get("description")) != null) {
                out.print("Description:   ");
                out.println(description);
            }
            out.println();
        }
        if (options.isEmpty()) {
            out.println();
        }
        return null;
    }
}

