/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.sblim.wbem.http.HttpHeader;
import org.sblim.wbem.http.HttpServerMethod;
import org.sblim.wbem.http.io.ASCIIPrintStream;
import org.sblim.wbem.http.io.ChunkedOutputStream;
import org.sblim.wbem.http.io.PersistentOutputStream;

public class MessageWriter {
    HttpHeader iHeader = null;
    HttpServerMethod iMethod = null;
    HttpHeader iTrailer = null;
    boolean iChunked = false;
    boolean iPersistent = false;
    ASCIIPrintStream iRealOS;
    ASCIIPrintStream iClientOS;
    ByteArrayOutputStream iBufferedOS;

    public MessageWriter(OutputStream ros, boolean persistent, boolean chunked) {
        this.iRealOS = new ASCIIPrintStream(ros);
        this.iChunked = chunked;
        this.iPersistent = persistent;
        this.iBufferedOS = new ByteArrayOutputStream();
        this.iClientOS = chunked ? new ASCIIPrintStream(new ChunkedOutputStream(new PersistentOutputStream(this.iBufferedOS, persistent), 512)) : new ASCIIPrintStream(new PersistentOutputStream(this.iBufferedOS, persistent));
        this.iHeader = new HttpHeader();
        this.iMethod = new HttpServerMethod(1, 1, 200, "OK");
    }

    public void reset() {
        this.iBufferedOS.reset();
    }

    public void setHeader(HttpHeader header) {
        this.iHeader = header;
    }

    public void setMethod(HttpServerMethod method) {
        this.iMethod = method;
    }

    public HttpHeader getHeader() {
        return this.iHeader;
    }

    public HttpServerMethod getMethod() {
        return this.iMethod;
    }

    public ASCIIPrintStream getOutputStream() {
        return this.iClientOS;
    }

    public void close() throws IOException {
        this.iMethod.write(this.iRealOS);
        this.iRealOS.flush();
        if (!this.iChunked) {
            this.iHeader.removeField("Transfer-Encoding");
        } else {
            this.iHeader.addField("Transfer-Encoding", "chunked");
        }
        if (this.iPersistent) {
            this.iHeader.addField("Connection", "Keep-alive");
        } else {
            this.iHeader.addField("Connection", "close");
        }
        this.iHeader.addField("Content-Type", "application/xml;charset=\"utf-8\"");
        if (!this.iChunked) {
            this.iHeader.addField("Content-length", Integer.toString(this.iBufferedOS.size()));
        }
        this.iHeader.write(this.iRealOS);
        this.iRealOS.flush();
        this.iBufferedOS.writeTo(this.iRealOS);
        if (this.iChunked && this.iTrailer != null) {
            this.iTrailer.write(this.iRealOS);
        }
        this.iRealOS.flush();
    }

    public void setTrailer(HttpHeader trailer) {
        this.iTrailer = trailer;
    }
}

