/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramEnrichment;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramVisitor;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.Array;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.FlowRecord;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.Interface;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.SFlowDataSource;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.SampleData;

public class FlowSample
implements SampleData {
    public final long sequence_number;
    public final SFlowDataSource source_id;
    public final long sampling_rate;
    public final long sample_pool;
    public final long drops;
    public final Interface input;
    public final Interface output;
    public final Array<FlowRecord> flow_records;

    public FlowSample(ByteBuf buffer) throws InvalidPacketException {
        this.sequence_number = BufferUtils.uint32((ByteBuf)buffer);
        this.source_id = new SFlowDataSource(buffer);
        this.sampling_rate = BufferUtils.uint32((ByteBuf)buffer);
        this.sample_pool = BufferUtils.uint32((ByteBuf)buffer);
        this.drops = BufferUtils.uint32((ByteBuf)buffer);
        this.input = new Interface(buffer);
        this.output = new Interface(buffer);
        this.flow_records = new Array<Object>(buffer, Optional.empty(), FlowRecord::new);
    }

    public FlowSample(long sequence_number, SFlowDataSource source_id, long sampling_rate, long sample_pool, long drops, Interface input, Interface output, Array<FlowRecord> flow_records) {
        this.sequence_number = sequence_number;
        this.source_id = source_id;
        this.sampling_rate = sampling_rate;
        this.sample_pool = sample_pool;
        this.drops = drops;
        this.input = input;
        this.output = output;
        this.flow_records = flow_records;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sequence_number", this.sequence_number).add("source_id", (Object)this.source_id).add("sampling_rate", this.sampling_rate).add("sample_pool", this.sample_pool).add("drops", this.drops).add("input", (Object)this.input).add("output", (Object)this.output).add("flow_records", this.flow_records).toString();
    }

    @Override
    public void writeBson(BsonWriter bsonWriter, SampleDatagramEnrichment enr) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeInt64("sequence_number", this.sequence_number);
        bsonWriter.writeName("source_id");
        this.source_id.writeBson(bsonWriter, enr);
        bsonWriter.writeInt64("sampling_rate", this.sampling_rate);
        bsonWriter.writeInt64("sample_pool", this.sample_pool);
        bsonWriter.writeInt64("drops", this.drops);
        bsonWriter.writeName("input");
        this.input.writeBson(bsonWriter, enr);
        bsonWriter.writeName("output");
        this.output.writeBson(bsonWriter, enr);
        bsonWriter.writeStartDocument("flows");
        for (FlowRecord flowRecord : this.flow_records) {
            bsonWriter.writeName(flowRecord.dataFormat.toId());
            flowRecord.writeBson(bsonWriter, enr);
        }
        bsonWriter.writeEndDocument();
        bsonWriter.writeEndDocument();
    }

    @Override
    public void visit(SampleDatagramVisitor visitor) {
        visitor.accept(this);
        for (FlowRecord flowRecord : this.flow_records) {
            flowRecord.visit(visitor);
        }
    }
}

