/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.nsclient.collector;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.collection.api.AbstractRemoteServiceCollector;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectionStatus;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.support.NumericAttributeUtils;
import org.opennms.netmgt.collection.support.builder.CollectionSetBuilder;
import org.opennms.netmgt.collection.support.builder.NodeLevelResource;
import org.opennms.netmgt.collection.support.builder.Resource;
import org.opennms.netmgt.config.datacollction.nsclient.Attrib;
import org.opennms.netmgt.config.datacollction.nsclient.NsclientCollection;
import org.opennms.netmgt.config.datacollction.nsclient.Wpm;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.protocols.nsclient.NSClientAgentConfig;
import org.opennms.protocols.nsclient.NsclientCheckParams;
import org.opennms.protocols.nsclient.NsclientException;
import org.opennms.protocols.nsclient.NsclientManager;
import org.opennms.protocols.nsclient.NsclientPacket;
import org.opennms.protocols.nsclient.config.NSClientDataCollectionConfigFactory;
import org.opennms.protocols.nsclient.config.NSClientPeerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSClientCollector
extends AbstractRemoteServiceCollector {
    private static final Logger LOG = LoggerFactory.getLogger(NSClientCollector.class);
    private static final String NSCLIENT_COLLECTION_KEY = "nsClientCollection";
    private static final String NSCLIENT_AGENT_CONFIG_KEY = "nsClientAgentConfig";
    private static final Map<String, Class<?>> TYPE_MAP = Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry<String, Class<NsclientCollection>>("nsClientCollection", NsclientCollection.class), new AbstractMap.SimpleEntry<String, Class<NSClientAgentConfig>>("nsClientAgentConfig", NSClientAgentConfig.class)).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Class)e.getValue())));

    public NSClientCollector() {
        super(TYPE_MAP);
    }

    public void initialize() {
        LOG.debug("initialize: Initializing NSClientCollector.");
        NSClientCollector.initNSClientPeerFactory();
        NSClientCollector.initNSClientCollectionConfig();
    }

    public Map<String, Object> getRuntimeAttributes(CollectionAgent agent, Map<String, Object> parameters) {
        HashMap<String, Object> runtimeAttributes = new HashMap<String, Object>();
        ServiceParameters serviceParams = new ServiceParameters(parameters);
        String collectionName = serviceParams.getCollectionName();
        NsclientCollection collection = NSClientDataCollectionConfigFactory.getInstance().getNSClientCollection(collectionName);
        if (collection == null) {
            throw new IllegalArgumentException(String.format("NSClientCollector: No collection found with name '%s'.", collectionName));
        }
        runtimeAttributes.put(NSCLIENT_COLLECTION_KEY, collection);
        NSClientAgentConfig agentConfig = NSClientPeerFactory.getInstance().getAgentConfig(agent.getAddress());
        runtimeAttributes.put(NSCLIENT_AGENT_CONFIG_KEY, agentConfig);
        return runtimeAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollectionSet collect(CollectionAgent agent, Map<String, Object> parameters) {
        CollectionSetBuilder builder = new CollectionSetBuilder(agent);
        builder.withStatus(CollectionStatus.FAILED);
        NsclientCollection collection = (NsclientCollection)parameters.get(NSCLIENT_COLLECTION_KEY);
        NSClientAgentConfig agentConfig = (NSClientAgentConfig)parameters.get(NSCLIENT_AGENT_CONFIG_KEY);
        NSClientAgentState agentState = new NSClientAgentState(agent.getAddress(), parameters, agentConfig);
        if (collection.getWpms().getWpm().size() < 1) {
            LOG.info("No groups to collect.");
            builder.withStatus(CollectionStatus.SUCCEEDED);
            return builder.build();
        }
        NodeLevelResource nodeResource = new NodeLevelResource(agent.getNodeId());
        for (Wpm wpm : collection.getWpms().getWpm()) {
            NsclientManager manager;
            if (agentState.shouldCheckAvailability(wpm.getName(), wpm.getRecheckInterval())) {
                LOG.debug("Checking availability of group {}", (Object)wpm.getName());
                manager = null;
                try {
                    manager = agentState.getManager();
                    manager.init();
                    NsclientCheckParams params = new NsclientCheckParams(wpm.getKeyvalue());
                    NsclientPacket result = manager.processCheckCommand("8", params);
                    manager.close();
                    boolean isAvailable = result.getResultCode() == 0;
                    agentState.setGroupIsAvailable(wpm.getName(), isAvailable);
                    LOG.debug("Group {} is {}available ", (Object)wpm.getName(), (Object)(isAvailable ? "" : "not"));
                }
                catch (NsclientException e) {
                    LOG.error("Error checking group ({}) availability", (Object)wpm.getName(), (Object)e);
                    agentState.setGroupIsAvailable(wpm.getName(), false);
                }
                finally {
                    if (manager != null) {
                        manager.close();
                    }
                }
            }
            if (!agentState.groupIsAvailable(wpm.getName())) continue;
            try {
                manager = agentState.getManager();
                manager.init();
                for (Attrib attrib : wpm.getAttrib()) {
                    NsclientPacket result = null;
                    try {
                        NsclientCheckParams params = new NsclientCheckParams(attrib.getName());
                        result = manager.processCheckCommand("8", params);
                    }
                    catch (NsclientException e) {
                        LOG.info("unable to collect params for attribute '{}'", (Object)attrib.getName(), (Object)e);
                    }
                    if (result == null) continue;
                    if (result.getResultCode() != 0) {
                        LOG.info("not writing parameters for attribute '{}', state is not 'OK'", (Object)attrib.getName());
                        continue;
                    }
                    builder.withNumericAttribute((Resource)nodeResource, wpm.getName(), attrib.getAlias(), (Number)NumericAttributeUtils.parseNumericValue((String)result.getResponse()), attrib.getType());
                }
                builder.withStatus(CollectionStatus.SUCCEEDED);
                manager.close();
            }
            catch (NsclientException e) {
                LOG.error("Error collecting data", (Throwable)e);
            }
        }
        return builder.build();
    }

    private static void initNSClientPeerFactory() {
        LOG.debug("initialize: Initializing NSClientPeerFactory");
        try {
            NSClientPeerFactory.init();
        }
        catch (IOException e) {
            LOG.error("initialize: Error reading configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    private static void initNSClientCollectionConfig() {
        LOG.debug("initialize: Initializing collector: {}", NSClientCollector.class);
        try {
            NSClientDataCollectionConfigFactory.init();
        }
        catch (FileNotFoundException e) {
            LOG.error("initialize: Error locating configuration.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (IOException e) {
            LOG.error("initialize: Error reading configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    public RrdRepository getRrdRepository(String collectionName) {
        return NSClientDataCollectionConfigFactory.getInstance().getRrdRepository(collectionName);
    }

    private static class NSClientAgentState {
        private final NsclientManager m_manager;
        private final String m_address;
        private final Map<String, NSClientGroupState> m_groupStates = new HashMap<String, NSClientGroupState>();

        public NSClientAgentState(InetAddress address, Map<String, Object> parameters, NSClientAgentConfig agentConfig) {
            this.m_address = InetAddressUtils.str((InetAddress)address);
            this.m_manager = new NsclientManager(this.m_address);
            this.m_manager.setPassword(agentConfig.getPassword());
            this.m_manager.setTimeout(agentConfig.getTimeout());
            this.m_manager.setPortNumber(agentConfig.getPort());
        }

        public NsclientManager getManager() {
            return this.m_manager;
        }

        public boolean groupIsAvailable(String groupName) {
            NSClientGroupState groupState = this.m_groupStates.get(groupName);
            if (groupState == null) {
                return false;
            }
            return groupState.isAvailable();
        }

        public void setGroupIsAvailable(String groupName, boolean available) {
            NSClientGroupState groupState = this.m_groupStates.get(groupName);
            if (groupState == null) {
                groupState = new NSClientGroupState(available);
            }
            groupState.setAvailable(available);
            this.m_groupStates.put(groupName, groupState);
        }

        public boolean shouldCheckAvailability(String groupName, int recheckInterval) {
            NSClientGroupState groupState = this.m_groupStates.get(groupName);
            if (groupState == null) {
                return true;
            }
            Date lastchecked = groupState.getLastChecked();
            Date now = new Date();
            return now.getTime() - lastchecked.getTime() > (long)recheckInterval;
        }

        public void didCheckGroupAvailability(String groupName) {
            NSClientGroupState groupState = this.m_groupStates.get(groupName);
            if (groupState == null) {
                LOG.warn("didCheckGroupAvailability called on a group without state - this is odd");
                return;
            }
            groupState.setLastChecked(new Date());
        }
    }

    private static class NSClientGroupState {
        private boolean available = false;
        private Date lastChecked;

        public NSClientGroupState(boolean isAvailable) {
            this(isAvailable, new Date());
        }

        public NSClientGroupState(boolean isAvailable, Date lastChecked) {
            this.available = isAvailable;
            this.lastChecked = lastChecked;
        }

        public boolean isAvailable() {
            return this.available;
        }

        public void setAvailable(boolean available) {
            this.available = available;
        }

        public Date getLastChecked() {
            return this.lastChecked;
        }

        public void setLastChecked(Date lastChecked) {
            this.lastChecked = lastChecked;
        }
    }
}

