/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.rpc.echo;

import java.util.concurrent.CompletableFuture;
import org.opennms.core.health.api.HealthCheckResponseCache;
import org.opennms.core.health.api.Response;
import org.opennms.core.rpc.echo.EchoRequest;
import org.opennms.core.rpc.echo.EchoResponse;
import org.opennms.core.rpc.echo.EchoRpcModule;
import org.opennms.core.rpc.xml.AbstractXmlRpcModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthTrackingEchoRpcModule
extends AbstractXmlRpcModule<EchoRequest, EchoResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(HealthTrackingEchoRpcModule.class);
    private final EchoRpcModule delegate;
    private final HealthCheckResponseCache healthCheckResponseCache;

    public HealthTrackingEchoRpcModule(EchoRpcModule delegate, HealthCheckResponseCache healthCheckResponseCache) {
        super(EchoRequest.class, EchoResponse.class);
        this.delegate = delegate;
        this.healthCheckResponseCache = healthCheckResponseCache;
    }

    public CompletableFuture<EchoResponse> execute(EchoRequest request) {
        LOG.debug("Received echo request - receivedTime: {}", (Object)request.getId());
        if (this.healthCheckResponseCache != null) {
            this.healthCheckResponseCache.setResponse(Response.SUCCESS);
        }
        return this.delegate.execute(request);
    }

    public String getId() {
        return "Echo";
    }

    public EchoResponse createResponseWithException(Throwable ex) {
        return this.delegate.createResponseWithException(ex);
    }
}

