/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class IteratorUtils<T> {
    @SafeVarargs
    public static <T> Iterable<T> concatIterators(Iterator<T> ... iterators) {
        return IteratorUtils.concatIterators(Arrays.asList(iterators));
    }

    public static <T> Iterable<T> concatIterators(List<Iterator<T>> iterators) {
        Stream stream = Stream.empty();
        for (Iterator<T> iterator : iterators) {
            stream = Stream.concat(stream, StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 1040), false));
        }
        return stream::iterator;
    }
}

