/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.proxy;

import java.util.Objects;
import org.opennms.netmgt.icmp.proxy.PingResponse;

public class PingSequence {
    private boolean timeout;
    private Throwable error;
    private PingResponse response;
    private int sequenceNumber;

    public PingSequence(int sequenceNumber, PingResponse response) {
        this.response = Objects.requireNonNull(response);
        this.sequenceNumber = sequenceNumber;
        this.timeout = response.getRtt() == Double.POSITIVE_INFINITY;
    }

    public PingSequence(int sequenceNumber, Throwable throwable) {
        this.error = Objects.requireNonNull(throwable);
        this.sequenceNumber = sequenceNumber;
    }

    public boolean isTimeout() {
        return this.timeout;
    }

    public boolean isError() {
        return this.error != null;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public Throwable getError() {
        return this.error;
    }

    public boolean isSuccess() {
        return !this.isTimeout() && !this.isError();
    }

    public PingResponse getResponse() {
        return this.response;
    }
}

