/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.twin.jms.subscriber;

import com.codahale.metrics.MetricRegistry;
import java.io.IOException;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointInject;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Synchronization;
import org.opennms.core.ipc.twin.api.TwinRequest;
import org.opennms.core.ipc.twin.api.TwinUpdate;
import org.opennms.core.ipc.twin.common.AbstractTwinSubscriber;
import org.opennms.core.ipc.twin.model.TwinRequestProto;
import org.opennms.core.tracing.api.TracerRegistry;
import org.opennms.core.utils.SystemInfoUtils;
import org.opennms.distributed.core.api.Identity;
import org.opennms.distributed.core.api.MinionIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsTwinSubscriber
extends AbstractTwinSubscriber
implements Processor {
    private static final String TWIN_QUEUE_NAME_FORMAT = "%s.%s";
    private static final Logger LOG = LoggerFactory.getLogger(JmsTwinSubscriber.class);
    @EndpointInject(uri="direct:twinRpc", context="twinRpcClient")
    private ProducerTemplate template;
    @EndpointInject(uri="direct:twinRpc", context="twinRpcClient")
    private Endpoint endpoint;
    private final Component queuingservice;
    private final String debugMaxChar;
    private final CamelContext sinkCamelContext = new DefaultCamelContext();

    public JmsTwinSubscriber(MinionIdentity minionIdentity, Component queuingservice, TracerRegistry tracerRegistry, MetricRegistry metricRegistry, String debugMaxChar) {
        super((Identity)minionIdentity, tracerRegistry, metricRegistry);
        this.queuingservice = queuingservice;
        this.debugMaxChar = debugMaxChar;
    }

    protected void sendRpcRequest(final TwinRequest twinRequest) {
        try {
            TwinRequestProto twinRequestProto = this.mapTwinRequestToProto(twinRequest);
            LOG.trace("Sent RPC request for consumer key {} ", (Object)twinRequestProto.getConsumerKey());
            this.template.asyncCallbackSendBody(this.endpoint, (Object)twinRequestProto.toByteArray(), new Synchronization(){

                public void onComplete(Exchange exchange) {
                    try {
                        byte[] response = (byte[])exchange.getOut().getBody(byte[].class);
                        TwinUpdate twinUpdate = JmsTwinSubscriber.this.mapTwinResponseToProto(response);
                        if (twinUpdate.getLocation() == null || twinUpdate.getLocation().equals(JmsTwinSubscriber.this.getIdentity().getLocation())) {
                            LOG.trace("Received TwinUpdate as RPC reply {}", (Object)twinUpdate);
                            JmsTwinSubscriber.this.accept(twinUpdate);
                        }
                    }
                    catch (Exception e) {
                        LOG.error("Failed to process twin update for the key {} ", (Object)twinRequest.getKey(), (Object)e);
                    }
                }

                public void onFailure(Exchange exchange) {
                }
            });
        }
        catch (Exception e) {
            LOG.error("Exception while sending request with key {}", (Object)twinRequest.getKey());
        }
    }

    public void init() throws Exception {
        this.sinkCamelContext.addComponent("queuingservice", this.queuingservice);
        this.sinkCamelContext.getGlobalOptions().put("CamelLogDebugBodyMaxChars", this.debugMaxChar);
        this.sinkCamelContext.addRoutes((RoutesBuilder)new SinkRouteBuilder(this));
        this.sinkCamelContext.start();
        LOG.info("JMS Twin subscriber initialized");
    }

    public void close() throws IOException {
        super.close();
        try {
            this.sinkCamelContext.stop();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        LOG.info("JMS Twin subscriber stopped");
    }

    public void process(Exchange exchange) throws Exception {
        byte[] sinkUpdateBytes = (byte[])exchange.getIn().getBody(byte[].class);
        TwinUpdate twinUpdate = this.mapTwinResponseToProto(sinkUpdateBytes);
        if (twinUpdate.getLocation() == null || twinUpdate.getLocation().equals(this.getIdentity().getLocation())) {
            LOG.trace("Received TwinResponse as sink update {}", (Object)twinUpdate);
            this.accept(twinUpdate);
        }
    }

    private class SinkRouteBuilder
    extends RouteBuilder {
        private final Processor processor;

        private SinkRouteBuilder(Processor processor) {
            super(JmsTwinSubscriber.this.sinkCamelContext);
            this.processor = processor;
        }

        public void configure() throws Exception {
            String queueName = String.format(JmsTwinSubscriber.TWIN_QUEUE_NAME_FORMAT, SystemInfoUtils.getInstanceId(), "Twin.Sink");
            JmsEndpoint endpoint = (JmsEndpoint)this.getContext().getEndpoint(String.format("queuingservice:topic:%s", queueName), JmsEndpoint.class);
            ((RouteDefinition)((RouteDefinition)this.from((Endpoint)endpoint).setExchangePattern(ExchangePattern.InOnly)).process(this.processor)).routeId(SystemInfoUtils.getInstanceId() + ".Twin.Sink");
        }
    }
}

