/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.twin.grpc.subscriber;

import com.codahale.metrics.MetricRegistry;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.grpc.Channel;
import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import org.opennms.core.grpc.common.GrpcIpcUtils;
import org.opennms.core.ipc.twin.api.TwinRequest;
import org.opennms.core.ipc.twin.api.TwinUpdate;
import org.opennms.core.ipc.twin.common.AbstractTwinSubscriber;
import org.opennms.core.ipc.twin.grpc.common.MinionHeader;
import org.opennms.core.ipc.twin.grpc.common.OpenNMSTwinIpcGrpc;
import org.opennms.core.ipc.twin.model.TwinRequestProto;
import org.opennms.core.ipc.twin.model.TwinResponseProto;
import org.opennms.core.tracing.api.TracerRegistry;
import org.opennms.distributed.core.api.Identity;
import org.opennms.distributed.core.api.MinionIdentity;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcTwinSubscriber
extends AbstractTwinSubscriber {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcTwinSubscriber.class);
    private static final long RETRIEVAL_TIMEOUT = 1000L;
    private static final int TWIN_REQUEST_POOL_SIZE = 100;
    private final int port;
    private final ConfigurationAdmin configAdmin;
    private ManagedChannel channel;
    private Properties clientProperties;
    private OpenNMSTwinIpcGrpc.OpenNMSTwinIpcStub asyncStub;
    private StreamObserver<TwinRequestProto> rpcStream;
    private AtomicBoolean isShutDown = new AtomicBoolean(false);
    private ResponseHandler responseHandler = new ResponseHandler();
    private final ThreadFactory twinRequestSenderThreadFactory = new ThreadFactoryBuilder().setNameFormat("twin-request-sender-%d").build();
    private final ScheduledExecutorService twinRequestSenderExecutor = Executors.newScheduledThreadPool(100, this.twinRequestSenderThreadFactory);

    public GrpcTwinSubscriber(MinionIdentity minionIdentity, ConfigurationAdmin configAdmin, TracerRegistry tracerRegistry, MetricRegistry metricRegistry, int port) {
        super((Identity)minionIdentity, tracerRegistry, metricRegistry);
        this.configAdmin = configAdmin;
        this.port = port;
    }

    public void start() throws IOException {
        this.clientProperties = GrpcIpcUtils.getPropertiesFromConfig((ConfigurationAdmin)this.configAdmin, (String)"org.opennms.core.ipc.grpc.client");
        this.channel = GrpcIpcUtils.getChannel((Properties)this.clientProperties, (int)this.port);
        this.asyncStub = OpenNMSTwinIpcGrpc.newStub((Channel)this.channel);
        this.retryInitializeRpcStream();
        LOG.info("Started Twin gRPC Subscriber at location {} with systemId {}", (Object)this.getIdentity().getLocation(), (Object)this.getIdentity().getId());
    }

    private boolean initRpcStream() {
        ConnectivityState currentChannelState = this.channel.getState(true);
        if (currentChannelState.equals((Object)ConnectivityState.READY) && this.rpcStream == null) {
            this.rpcStream = this.asyncStub.rpcStreaming((StreamObserver)this.responseHandler);
            this.sendMinionHeader();
            return true;
        }
        return false;
    }

    private void retryInitializeRpcStream() {
        this.scheduleWithDelayUntilGetSucceeds(this.twinRequestSenderExecutor, this::initRpcStream, 1000L);
    }

    private synchronized void sendMinionHeader() {
        MinionHeader minionHeader = MinionHeader.newBuilder().setLocation(this.getIdentity().getLocation()).setSystemId(this.getIdentity().getId()).build();
        this.asyncStub.sinkStreaming(minionHeader, (StreamObserver)this.responseHandler);
    }

    public void close() throws IOException {
        this.isShutDown.set(true);
        super.close();
        if (this.channel != null) {
            this.channel.shutdown();
        }
        this.twinRequestSenderExecutor.shutdown();
    }

    protected void sendRpcRequest(TwinRequest twinRequest) {
        try {
            TwinRequestProto twinRequestProto = this.mapTwinRequestToProto(twinRequest);
            CompletableFuture.runAsync(() -> this.retrySendRpcRequest(twinRequestProto), this.twinRequestSenderExecutor);
        }
        catch (Exception e) {
            LOG.error("Exception while sending request with key {}", (Object)twinRequest.getKey());
        }
    }

    private void retrySendRpcRequest(TwinRequestProto twinRequestProto) {
        this.scheduleWithDelayUntilFunctionSucceeds(this.twinRequestSenderExecutor, this::sendTwinRpcRequest, 1000L, twinRequestProto);
    }

    private <T> void scheduleWithDelayUntilFunctionSucceeds(ScheduledExecutorService executorService, Function<T, Boolean> function, long delayInMsec, T obj) {
        boolean succeeded = function.apply(obj);
        if (!succeeded) {
            do {
                ScheduledFuture<Boolean> future = executorService.schedule(() -> (Boolean)function.apply(obj), delayInMsec, TimeUnit.MILLISECONDS);
                try {
                    succeeded = (Boolean)future.get();
                    if (!succeeded) continue;
                    break;
                }
                catch (Exception e) {
                    succeeded = true;
                    LOG.warn("Error while attempting to schedule the task", (Throwable)e);
                }
            } while (!succeeded || !this.isShutDown.get());
        }
    }

    private void scheduleWithDelayUntilGetSucceeds(ScheduledExecutorService executorService, Supplier<Boolean> supplier, long delayInMsec) {
        boolean succeeded = supplier.get();
        if (!succeeded) {
            do {
                ScheduledFuture<Boolean> future = executorService.schedule(() -> (Boolean)supplier.get(), delayInMsec, TimeUnit.MILLISECONDS);
                try {
                    succeeded = (Boolean)future.get();
                    if (!succeeded) continue;
                    break;
                }
                catch (Exception e) {
                    succeeded = true;
                    LOG.warn("Error while attempting to schedule the task", (Throwable)e);
                }
            } while (!succeeded || !this.isShutDown.get());
        }
    }

    private synchronized boolean sendTwinRpcRequest(TwinRequestProto twinRequestProto) {
        if (this.rpcStream == null) {
            this.initRpcStream();
        }
        if (this.rpcStream != null) {
            this.rpcStream.onNext((Object)twinRequestProto);
            return true;
        }
        return false;
    }

    private class ResponseHandler
    implements StreamObserver<TwinResponseProto> {
        private ResponseHandler() {
        }

        public void onNext(TwinResponseProto twinResponseProto) {
            try {
                TwinUpdate twinUpdate = GrpcTwinSubscriber.this.mapTwinResponseToProto(twinResponseProto.toByteArray());
                GrpcTwinSubscriber.this.accept(twinUpdate);
            }
            catch (Exception e) {
                LOG.error("Exception while processing twin update for key {} ", (Object)twinResponseProto.getConsumerKey(), (Object)e);
            }
        }

        public void onError(Throwable throwable) {
            LOG.error("Error in Twin streaming", throwable);
            GrpcTwinSubscriber.this.rpcStream = null;
            CompletableFuture.runAsync(() -> GrpcTwinSubscriber.this.retryInitializeRpcStream(), GrpcTwinSubscriber.this.twinRequestSenderExecutor);
        }

        public void onCompleted() {
            LOG.error("Closing Twin Response Handler");
            GrpcTwinSubscriber.this.rpcStream = null;
            CompletableFuture.runAsync(() -> GrpcTwinSubscriber.this.retryInitializeRpcStream(), GrpcTwinSubscriber.this.twinRequestSenderExecutor);
        }
    }
}

