/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.sink.aggregation;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.opennms.core.ipc.sink.api.AggregationPolicy;

public class ArrayListAggregationPolicy<S>
implements AggregationPolicy<S, List<S>, List<S>> {
    private final int m_completionSize;
    private final int m_completionInterval;
    private final Function<S, Object> m_keyMapper;

    public ArrayListAggregationPolicy(int completionSize, int completionInterval, Function<S, Object> keyMapper) {
        this.m_completionSize = completionSize;
        this.m_completionInterval = completionInterval;
        this.m_keyMapper = keyMapper;
    }

    public Object key(S message) {
        return this.m_keyMapper.apply(message);
    }

    public List<S> aggregate(List<S> accumulator, S newMessage) {
        if (accumulator == null) {
            accumulator = new ArrayList<S>(this.m_completionSize);
        }
        accumulator.add(newMessage);
        return accumulator;
    }

    public List<S> build(List<S> accumulator) {
        return accumulator;
    }

    public int getCompletionSize() {
        return this.m_completionSize;
    }

    public int getCompletionIntervalMs() {
        return this.m_completionInterval;
    }
}

