/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.client.rpc;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.opennms.core.mate.api.FallbackScope;
import org.opennms.core.mate.api.Interpolator;
import org.opennms.core.mate.api.Scope;
import org.opennms.core.rpc.api.RpcRequest;
import org.opennms.core.rpc.api.RpcTarget;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectorRequestBuilder;
import org.opennms.netmgt.collection.api.ServiceCollector;
import org.opennms.netmgt.collection.client.rpc.CollectorRequestDTO;
import org.opennms.netmgt.collection.client.rpc.CollectorResponseDTO;
import org.opennms.netmgt.collection.client.rpc.LocationAwareCollectorClientImpl;
import org.opennms.netmgt.collection.dto.CollectionAgentDTO;
import org.opennms.netmgt.dao.api.MonitoringLocationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectorRequestBuilderImpl
implements CollectorRequestBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(CollectorRequestBuilderImpl.class);
    private final LocationAwareCollectorClientImpl client;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private CollectionAgent agent;
    private String systemId;
    private ServiceCollector serviceCollector;
    private Long ttlInMs;
    private String className;

    public CollectorRequestBuilderImpl(LocationAwareCollectorClientImpl client) {
        this.client = Objects.requireNonNull(client);
    }

    public CollectorRequestBuilder withAgent(CollectionAgent agent) {
        this.agent = agent;
        return this;
    }

    public CollectorRequestBuilder withSystemId(String systemId) {
        this.systemId = systemId;
        return this;
    }

    public CollectorRequestBuilder withCollector(ServiceCollector collector) {
        this.serviceCollector = collector;
        return this;
    }

    public CollectorRequestBuilder withCollectorClassName(String className) {
        this.className = className;
        this.serviceCollector = this.client.getRegistry().getCollectorFutureByClassName(className).getNow(null);
        return this;
    }

    public CollectorRequestBuilder withTimeToLive(Long ttlInMs) {
        this.ttlInMs = ttlInMs;
        return this;
    }

    public CollectorRequestBuilder withAttribute(String key, Object value) {
        this.attributes.put(key, value);
        return this;
    }

    public CollectorRequestBuilder withAttributes(Map<String, Object> attributes) {
        this.attributes.putAll(attributes);
        return this;
    }

    public CompletableFuture<CollectionSet> execute() {
        if (this.serviceCollector == null) {
            throw new IllegalArgumentException("Collector or collector class name is required.");
        }
        if (this.agent == null) {
            throw new IllegalArgumentException("Agent is required.");
        }
        FallbackScope scope = new FallbackScope(new Scope[]{this.client.getEntityScopeProvider().getScopeForNode(Integer.valueOf(this.agent.getNodeId())), this.client.getEntityScopeProvider().getScopeForInterface(Integer.valueOf(this.agent.getNodeId()), InetAddressUtils.toIpAddrString((InetAddress)this.agent.getAddress()))});
        Map interpolatedAttributes = Interpolator.interpolateObjects(this.attributes, (Scope)scope);
        RpcTarget target = this.client.getRpcTargetHelper().target().withNodeId(Integer.valueOf(this.agent.getNodeId())).withLocation(this.agent.getLocationName()).withSystemId(this.systemId).withServiceAttributes(interpolatedAttributes).withLocationOverride(s -> this.serviceCollector.getEffectiveLocation(s)).build();
        CollectorRequestDTO request = new CollectorRequestDTO();
        request.setLocation(target.getLocation());
        request.setSystemId(target.getSystemId());
        String collectorClassName = this.className != null ? this.className : this.serviceCollector.getClass().getCanonicalName();
        request.setClassName(collectorClassName);
        this.ttlInMs = ParameterMap.getLongValue((String)"ttl", interpolatedAttributes.get("ttl"), (Long)this.ttlInMs);
        request.setTimeToLiveMs(this.ttlInMs);
        request.addTracingInfo("nodeId", String.valueOf(this.agent.getNodeId()));
        request.addTracingInfo("nodeLabel", this.agent.getNodeLabel());
        request.addTracingInfo("className", collectorClassName);
        request.addTracingInfo("ipAddress", InetAddressUtils.toIpAddrString((InetAddress)this.agent.getAddress()));
        Map runtimeAttributes = Interpolator.interpolateAttributes((Map)this.serviceCollector.getRuntimeAttributes(this.agent, interpolatedAttributes), (Scope)scope);
        HashMap<String, Object> allAttributes = new HashMap<String, Object>();
        allAttributes.putAll(interpolatedAttributes);
        allAttributes.putAll(runtimeAttributes);
        if (MonitoringLocationUtils.isDefaultLocationName((String)request.getLocation())) {
            request.setAgent(this.agent);
            request.addAttributes(allAttributes);
        } else {
            request.setAgent((CollectionAgent)new CollectionAgentDTO(this.agent));
            Map marshaledParms = this.serviceCollector.marshalParameters(allAttributes);
            marshaledParms.forEach(request::addAttribute);
            request.setAttributesNeedUnmarshaling(true);
        }
        return this.client.getDelegate().execute((RpcRequest)request).thenApply(CollectorResponseDTO::getCollectionSet);
    }
}

