/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.twin.shell;

import java.io.Closeable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.core.ipc.twin.api.TwinSubscriber;
import org.opennms.core.ipc.twin.shell.TwinKeyCompleter;

@Command(scope="opennms", name="twin-subscribe", description="Get current Twin Object for the key specified")
@Service
public class TwinSubscriberCommand
implements Action {
    @Reference
    private TwinSubscriber twinSubscriber;
    @Argument(index=0, name="consumer-key", description="Consumer key", required=true)
    @Completion(value=TwinKeyCompleter.class)
    private String key;
    @Option(name="-t", aliases={"--timeout in ms"}, description="Session timeout before closing session")
    private long timeout = 15000L;

    public Object execute() throws Exception {
        Class<?> clazz = TwinKeyCompleter.twinClazzMap.get(this.key);
        if (clazz == null) {
            System.err.println("Unknown key: " + this.key);
            return null;
        }
        CompletableFuture received = new CompletableFuture();
        try (Closeable subscription = this.twinSubscriber.subscribe(this.key, clazz, received::complete);){
            Object result = received.get(this.timeout, TimeUnit.MILLISECONDS);
            System.out.println("Object returned for key:" + this.key);
            System.out.println(result);
        }
        catch (TimeoutException e) {
            System.err.println("Timeout");
        }
        return null;
    }
}

