/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.topologies.service.api;

import java.util.HashSet;
import java.util.Set;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyEdge;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyVertex;

public class OnmsTopology {
    private Set<OnmsTopologyVertex> m_vertices = new HashSet<OnmsTopologyVertex>();
    private Set<OnmsTopologyEdge> m_edges = new HashSet<OnmsTopologyEdge>();
    private OnmsTopologyVertex m_defaultVertex;

    public OnmsTopologyVertex getVertex(String id) {
        return this.m_vertices.stream().filter(vertex -> id.equals(vertex.getId())).findAny().orElse(null);
    }

    public OnmsTopologyEdge getEdge(String id) {
        return this.m_edges.stream().filter(edge -> id.equals(edge.getId())).findAny().orElse(null);
    }

    public Set<OnmsTopologyVertex> getVertices() {
        return this.m_vertices;
    }

    public void addVertex(OnmsTopologyVertex v) {
        this.m_vertices.add(v);
    }

    public void setVertices(Set<OnmsTopologyVertex> vertices) {
        this.m_vertices = vertices;
    }

    public Set<OnmsTopologyEdge> getEdges() {
        return this.m_edges;
    }

    public void addEdge(OnmsTopologyEdge e) {
        this.m_edges.add(e);
    }

    public void setEdges(Set<OnmsTopologyEdge> edges) {
        this.m_edges = edges;
    }

    public boolean hasVertex(String id) {
        return this.getVertex(id) != null;
    }

    public boolean hasEdge(String id) {
        return this.getEdge(id) != null;
    }

    public OnmsTopology clone() {
        OnmsTopology topo = new OnmsTopology();
        topo.setVertices(new HashSet<OnmsTopologyVertex>(this.m_vertices));
        topo.setEdges(new HashSet<OnmsTopologyEdge>(this.m_edges));
        topo.setDefaultVertex(this.m_defaultVertex);
        return topo;
    }

    public OnmsTopologyVertex getDefaultVertex() {
        return this.m_defaultVertex;
    }

    public void setDefaultVertex(OnmsTopologyVertex defaultVertex) {
        this.m_defaultVertex = defaultVertex;
    }
}

