/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo;

import com.vmware.vim25.FileFault;
import com.vmware.vim25.GuestAuthentication;
import com.vmware.vim25.GuestOperationsFault;
import com.vmware.vim25.GuestProcessInfo;
import com.vmware.vim25.GuestProgramSpec;
import com.vmware.vim25.InvalidState;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.TaskInProgress;
import com.vmware.vim25.mo.ManagedObject;
import com.vmware.vim25.mo.ServerConnection;
import com.vmware.vim25.mo.VirtualMachine;
import java.rmi.RemoteException;

public class GuestProcessManager
extends ManagedObject {
    private VirtualMachine vm = null;

    public GuestProcessManager(ServerConnection sc, ManagedObjectReference mor, VirtualMachine vm) {
        super(sc, mor);
        this.vm = vm;
    }

    public VirtualMachine getVM() {
        return this.vm;
    }

    public GuestProcessInfo[] listProcessesInGuest(GuestAuthentication auth, long[] pids) throws GuestOperationsFault, InvalidState, TaskInProgress, RuntimeFault, RemoteException {
        return this.getVimService().listProcessesInGuest(this.getMOR(), this.vm.getMOR(), auth, pids);
    }

    public String[] readEnvironmentVariableInGuest(GuestAuthentication auth, String[] names) throws GuestOperationsFault, InvalidState, TaskInProgress, RuntimeFault, RemoteException {
        return this.getVimService().readEnvironmentVariableInGuest(this.getMOR(), this.vm.getMOR(), auth, names);
    }

    public long startProgramInGuest(GuestAuthentication auth, GuestProgramSpec spec) throws GuestOperationsFault, InvalidState, TaskInProgress, FileFault, RuntimeFault, RemoteException {
        return this.getVimService().startProgramInGuest(this.getMOR(), this.vm.getMOR(), auth, spec);
    }

    public void terminateProcessInGuest(GuestAuthentication auth, long pid) throws GuestOperationsFault, InvalidState, TaskInProgress, RuntimeFault, RemoteException {
        this.getVimService().terminateProcessInGuest(this.getMOR(), this.vm.getMOR(), auth, pid);
    }
}

