/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.util.Map;
import org.opennms.core.soa.ServiceRegistry;
import org.opennms.core.soa.lookup.ServiceLookup;
import org.opennms.core.soa.lookup.ServiceLookupBuilder;
import org.opennms.core.soa.lookup.ServiceRegistryLookup;
import org.opennms.core.soa.support.DefaultServiceRegistry;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.features.dhcpd.Dhcpd;
import org.opennms.features.dhcpd.Transaction;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.support.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DhcpMonitor
extends AbstractServiceMonitor {
    public static final int DEFAULT_RETRIES = 0;
    public static final int DEFAULT_TIMEOUT = 3000;
    public static final String DEFAULT_MAC_ADDRESS = "00:06:0D:BE:9C:B2";
    private static final Logger LOG = LoggerFactory.getLogger(DhcpMonitor.class);
    private final ServiceLookup<Class<?>, String> SERVICE_LOOKUP = new ServiceLookupBuilder((ServiceLookup)new ServiceRegistryLookup((ServiceRegistry)DefaultServiceRegistry.INSTANCE)).blocking().build();
    private Dhcpd dhcpd;

    public void setDhcpd(Dhcpd dhcpd) {
        this.dhcpd = dhcpd;
    }

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        if (this.dhcpd == null) {
            this.dhcpd = (Dhcpd)this.SERVICE_LOOKUP.lookup(Dhcpd.class, null);
        }
        int retries = ParameterMap.getKeyedInteger(parameters, (String)"retry", (int)0);
        int timeout = ParameterMap.getKeyedInteger(parameters, (String)"timeout", (int)3000);
        String macAddress = ParameterMap.getKeyedString(parameters, (String)"macAddress", (String)DEFAULT_MAC_ADDRESS);
        boolean relayMode = ParameterMap.getKeyedBoolean(parameters, (String)"relayMode", (boolean)false);
        boolean extendedMode = ParameterMap.getKeyedBoolean(parameters, (String)"extendedMode", (boolean)false);
        String myAddress = ParameterMap.getKeyedString(parameters, (String)"myIpAddress", (String)"127.0.0.1");
        String requestIpAddress = ParameterMap.getKeyedString(parameters, (String)"requestIpAddress", (String)"127.0.0.1");
        TimeoutTracker tracker = new TimeoutTracker(parameters, retries, timeout);
        Transaction transaction = null;
        tracker.reset();
        while (tracker.shouldRetry() && (transaction == null || !transaction.isSuccess())) {
            try {
                transaction = this.dhcpd.executeTransaction(svc.getIpAddr(), macAddress, relayMode, myAddress, extendedMode, requestIpAddress, timeout);
            }
            catch (IOException e) {
                LOG.error("An unexpected exception occurred during DHCP polling", (Throwable)e);
                return PollStatus.unavailable((String)("An unexpected exception occurred during DHCP polling: " + e.getMessage()));
            }
            tracker.nextAttempt();
        }
        return transaction != null && transaction.isSuccess() ? PollStatus.available((Double)Double.valueOf(transaction.getResponseTime())) : PollStatus.unavailable((String)("DHCP service unavailable: No response received from " + svc.getIpAddr() + " within " + timeout + " and " + retries + " attempt(s). Relay Mode: " + relayMode + ", Extended Mode " + extendedMode + ", Relay IP address: " + myAddress + ", Request IP address: " + requestIpAddress + ", MAC address: " + macAddress + ". "));
    }
}

