/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.notificationCommands.Command;
import org.opennms.netmgt.config.notificationCommands.NotificationCommands;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NotificationCommandManager {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationCommandManager.class);
    private Map<String, Command> m_commands;

    protected void parseXML(InputStream stream) throws IOException {
        NotificationCommands config;
        try (InputStreamReader reader = new InputStreamReader(stream);){
            config = (NotificationCommands)JaxbUtils.unmarshal(NotificationCommands.class, (Reader)reader);
        }
        HashMap<String, Command> commands = new HashMap<String, Command>();
        for (Command curCommand : NotificationCommandManager.getCommandsFromConfig(config)) {
            if (curCommand != null && curCommand.getName() != null) {
                commands.put(curCommand.getName(), curCommand);
                continue;
            }
            LOG.warn("invalid notification command: {}", (Object)curCommand);
        }
        this.m_commands = commands;
    }

    private static List<Command> getCommandsFromConfig(NotificationCommands config) {
        if (config == null) {
            LOG.warn("no notification commands found");
            return Collections.emptyList();
        }
        return config.getCommands();
    }

    public abstract void update() throws Exception;

    public Command getCommand(String name) {
        return this.m_commands.get(name);
    }

    public Map<String, Command> getCommands() {
        return Collections.unmodifiableMap(this.m_commands);
    }
}

