/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.InetAddress;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.io.IOUtils;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.collectd.CollectdConfiguration;
import org.opennms.netmgt.config.collectd.Collector;
import org.opennms.netmgt.config.collectd.Package;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectdConfigFactory
implements org.opennms.netmgt.config.api.CollectdConfigFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CollectdConfigFactory.class);
    public static final String SELECT_METHOD_MIN = "min";
    private CollectdConfiguration localCollectdConfig;
    private final Object m_collectdConfigMutex = new Object();
    private final String m_fileName;
    private List<Package> extendedPackages = Collections.emptyList();
    private List<Package> mergedPackages = Collections.emptyList();
    private List<Collector> extendedCollectors = Collections.emptyList();
    private List<Collector> mergedCollectors = Collections.emptyList();

    public CollectdConfigFactory() throws IOException {
        this.m_fileName = ConfigFileConstants.getFile((int)ConfigFileConstants.COLLECTD_CONFIG_FILE_NAME).getPath();
        this.init(new FileInputStream(this.m_fileName));
    }

    public CollectdConfigFactory(InputStream stream) throws IOException {
        this.m_fileName = null;
        this.init(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(InputStream stream) throws IOException {
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader(stream);
            CollectdConfiguration config = (CollectdConfiguration)JaxbUtils.unmarshal(CollectdConfiguration.class, (Reader)isr);
            Object object = this.m_collectdConfigMutex;
            synchronized (object) {
                this.localCollectdConfig = config;
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(isr);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)isr);
        this.setUpInternalData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUpInternalData() {
        Object object = this.m_collectdConfigMutex;
        synchronized (object) {
            this.mergedCollectors = ListUtils.union((List)this.localCollectdConfig.getCollectors(), this.extendedCollectors);
            this.mergedPackages = ListUtils.union((List)this.localCollectdConfig.getPackages(), this.extendedPackages);
        }
    }

    public void reload() throws IOException {
        this.init(new FileInputStream(this.m_fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCurrent() throws IOException {
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.COLLECTD_CONFIG_FILE_NAME);
        CollectdConfiguration config = null;
        Object object = this.m_collectdConfigMutex;
        synchronized (object) {
            config = this.localCollectdConfig;
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(cfgFile);
            JaxbUtils.marshal((Object)config, (Writer)writer);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)writer);
        this.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollectdConfiguration getLocalCollectdConfig() {
        Object object = this.m_collectdConfigMutex;
        synchronized (object) {
            return this.localCollectdConfig;
        }
    }

    public Integer getThreads() {
        return this.localCollectdConfig.getThreads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean packageExists(String name) {
        Object object = this.m_collectdConfigMutex;
        synchronized (object) {
            for (Package pkg : this.mergedPackages) {
                if (!pkg.getName().equals(name)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Package getPackage(String name) {
        Object object = this.m_collectdConfigMutex;
        synchronized (object) {
            for (Package pkg : this.mergedPackages) {
                if (!pkg.getName().equals(name)) continue;
                return pkg;
            }
            return null;
        }
    }

    public List<Package> getPackages() {
        return this.mergedPackages;
    }

    public List<Collector> getCollectors() {
        return this.mergedCollectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean domainExists(String name) {
        Object object = this.m_collectdConfigMutex;
        synchronized (object) {
            for (Package pkg : this.mergedPackages) {
                if (pkg.getIfAliasDomain() == null || !pkg.getIfAliasDomain().equals(name)) continue;
                return true;
            }
            return false;
        }
    }

    public boolean isServiceCollectionEnabled(OnmsMonitoredService service) {
        return this.isServiceCollectionEnabled(service.getIpInterface(), service.getServiceName());
    }

    public boolean isServiceCollectionEnabled(OnmsIpInterface iface, String svcName) {
        for (Package wpkg : this.mergedPackages) {
            if (!this.interfaceInPackage(iface, wpkg) || !wpkg.serviceInPackageAndEnabled(svcName)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isServiceCollectionEnabled(String ipAddr, String svcName) {
        Object object = this.m_collectdConfigMutex;
        synchronized (object) {
            for (Package wpkg : this.mergedPackages) {
                if (!this.interfaceInPackage(ipAddr, wpkg) || !wpkg.serviceInPackageAndEnabled(svcName)) continue;
                return true;
            }
            return false;
        }
    }

    public boolean interfaceInFilter(String iface, Package pkg) {
        String filter = pkg.getFilter().getContent();
        if (iface == null) {
            return false;
        }
        InetAddress ifaceAddress = InetAddressUtils.addr((String)iface);
        boolean filterPassed = false;
        LOG.debug("interfaceInFilter: package is {}. filter rules are {}", (Object)pkg.getName(), (Object)filter);
        try {
            List ipList = FilterDaoFactory.getInstance().getActiveIPAddressList(filter);
            filterPassed = ipList.contains(ifaceAddress);
            if (!filterPassed) {
                LOG.debug("interfaceInFilter: Interface {} passed filter for package {}?: false", (Object)iface, (Object)pkg.getName());
            }
        }
        catch (Throwable t) {
            LOG.error("interfaceInFilter: Failed to map package: {} to an IP List with filter \"{}\"", new Object[]{pkg.getName(), pkg.getFilter().getContent(), t});
        }
        return filterPassed;
    }

    public boolean interfaceInPackage(String iface, Package pkg) {
        boolean packagePassed;
        boolean filterPassed = this.interfaceInFilter(iface, pkg);
        if (!filterPassed) {
            return false;
        }
        byte[] addr = InetAddressUtils.toIpAddrBytes((String)iface);
        boolean has_range_include = pkg.hasIncludeRange(iface);
        boolean has_specific = pkg.hasSpecific(addr);
        has_specific = pkg.hasSpecificUrl(iface, has_specific);
        boolean has_range_exclude = pkg.hasExcludeRange(iface);
        boolean bl = packagePassed = has_specific || has_range_include && !has_range_exclude;
        if (packagePassed) {
            LOG.info("interfaceInPackage: Interface {} passed filter and specific/range for package {}?: {}", new Object[]{iface, pkg.getName(), packagePassed});
        } else {
            LOG.debug("interfaceInPackage: Interface {} passed filter and specific/range for package {}?: {}", new Object[]{iface, pkg.getName(), packagePassed});
        }
        return packagePassed;
    }

    public boolean interfaceInPackage(OnmsIpInterface iface, Package pkg) {
        return this.interfaceInPackage(iface.getIpAddressAsString(), pkg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExternalData(List<Package> packages, List<Collector> collectors) {
        Object object = this.m_collectdConfigMutex;
        synchronized (object) {
            this.extendedPackages = packages;
            this.extendedCollectors = collectors;
            this.setUpInternalData();
        }
    }
}

