/*
 * Licensed to The OpenNMS Group, Inc (TOG) under one or more
 * contributor license agreements.  See the LICENSE.md file
 * distributed with this work for additional information
 * regarding copyright ownership.
 *
 * TOG licenses this file to You under the GNU Affero General
 * Public License Version 3 (the "License") or (at your option)
 * any later version.  You may not use this file except in
 * compliance with the License.  You may obtain a copy of the
 * License at:
 *
 *      https://www.gnu.org/licenses/agpl-3.0.txt
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.  See the License for the specific
 * language governing permissions and limitations under the
 * License.
 */
package org.opennms.netmgt.config.wmi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://xmlns.opennms.org/xsd/config/wmi-datacollection}wmi-collection" maxOccurs="unbounded"/&gt;
 *       &lt;/sequence&gt;
 *       &lt;attribute name="rrdRepository" use="required" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.NONE)
@XmlType(name = "", propOrder = {
        "m_wmiCollections"
})
@XmlRootElement(name = "wmi-datacollection-config")
@ValidateUsing("wmi-datacollection.xsd")
public class WmiDatacollectionConfig implements Serializable {
    private static final long serialVersionUID = 2L;

    @XmlElement(name = "wmi-collection", required = true)
    protected List<WmiCollection> m_wmiCollections = new ArrayList<>();

    @XmlAttribute(name = "rrdRepository", required = true)
    protected String m_rrdRepository;

    public List<WmiCollection> getWmiCollections() {
        return m_wmiCollections;
    }

    public void setWmiCollections(final List<WmiCollection> wmiCollections) {
        if (wmiCollections == m_wmiCollections) return;
        m_wmiCollections.clear();
        if (wmiCollections != null) m_wmiCollections.addAll(wmiCollections);
    }

    public void addWmiCollection(final WmiCollection wmiCollection) {
        m_wmiCollections.add(wmiCollection);
    }

    public boolean removeWmiCollection(final WmiCollection wmiCollection) {
        return m_wmiCollections.remove(wmiCollection);
    }

    public String getRrdRepository() {
        return m_rrdRepository;
    }

    public void setRrdRepository(final String rrdRepository) {
        m_rrdRepository = ConfigUtils.assertNotEmpty(rrdRepository, "rrdRepository");
    }

    @Override
    public boolean equals(final Object obj) {
        if (!(obj instanceof WmiDatacollectionConfig)) {
            return false;
        }
        final WmiDatacollectionConfig that = (WmiDatacollectionConfig) obj;
        return Objects.equals(this.m_wmiCollections, that.m_wmiCollections)
                && Objects.equals(this.m_rrdRepository, that.m_rrdRepository);
    }

    @Override
    public int hashCode() {
        return Objects.hash(m_wmiCollections, m_rrdRepository);
    }

}
