/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.builder.smart;

import com.google.common.collect.ImmutableMap;
import io.takari.maven.builder.smart.DependencyGraph;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.project.MavenProject;

class ProjectComparator {
    ProjectComparator() {
    }

    public static Comparator<MavenProject> create(MavenSession session) {
        ProjectDependencyGraph dependencyGraph = session.getProjectDependencyGraph();
        return ProjectComparator.create0(DependencyGraph.fromMaven(dependencyGraph), (Map<String, AtomicLong>)ImmutableMap.of(), p -> ProjectComparator.id(p));
    }

    static <K> Comparator<K> create0(DependencyGraph<K> dependencyGraph, Map<String, AtomicLong> historicalServiceTimes, final Function<K, String> toKey) {
        long defaultServiceTime = ProjectComparator.average(historicalServiceTimes.values());
        HashMap<K, Long> serviceTimes = new HashMap<K, Long>();
        HashSet<K> rootProjects = new HashSet<K>();
        for (K project : dependencyGraph.getSortedProjects()) {
            Long serviceTime = ProjectComparator.getServiceTime(historicalServiceTimes, project, defaultServiceTime, toKey);
            serviceTimes.put(project, serviceTime);
            if (!dependencyGraph.getUpstreamProjects(project).isEmpty()) continue;
            rootProjects.add(project);
        }
        final Map<K, Long> projectWeights = ProjectComparator.calculateWeights(dependencyGraph, serviceTimes, rootProjects);
        return new Comparator<K>(){

            @Override
            public int compare(K o1, K o2) {
                long delta = (Long)projectWeights.get(o2) - (Long)projectWeights.get(o1);
                if (delta > 0L) {
                    return 1;
                }
                if (delta < 0L) {
                    return -1;
                }
                return ((String)toKey.apply(o2)).compareTo((String)toKey.apply(o1));
            }
        };
    }

    private static long average(Collection<AtomicLong> values) {
        long count = 0L;
        long sum = 0L;
        for (AtomicLong value : values) {
            if (value == null) continue;
            sum += value.longValue();
            ++count;
        }
        long average = 0L;
        if (count > 0L) {
            average = sum / count;
        }
        if (average == 0L) {
            average = 1L;
        }
        return average;
    }

    private static <K> Long getServiceTime(Map<String, AtomicLong> serviceTimes, K project, long defaultServiceTime, Function<K, String> toKey) {
        AtomicLong serviceTime = serviceTimes.get(toKey.apply(project));
        return serviceTime != null ? serviceTime.longValue() : defaultServiceTime;
    }

    private static <K> Map<K, Long> calculateWeights(DependencyGraph<K> dependencyGraph, Map<K, Long> serviceTimes, Collection<K> rootProjects) {
        HashMap weights = new HashMap();
        for (K rootProject : rootProjects) {
            ProjectComparator.calculateWeights(dependencyGraph, serviceTimes, rootProject, weights);
        }
        return weights;
    }

    private static <K> long calculateWeights(DependencyGraph<K> dependencyGraph, Map<K, Long> serviceTimes, K project, Map<K, Long> weights) {
        long weight = serviceTimes.get(project);
        for (K successor : dependencyGraph.getDownstreamProjects(project)) {
            long successorWeight = weights.containsKey(successor) ? weights.get(successor) : ProjectComparator.calculateWeights(dependencyGraph, serviceTimes, successor, weights);
            weight = Math.max(weight, serviceTimes.get(project) + successorWeight);
        }
        weights.put(project, weight);
        return weight;
    }

    static String id(MavenProject project) {
        StringBuilder sb = new StringBuilder();
        sb.append(project.getGroupId());
        sb.append(':');
        sb.append(project.getArtifactId());
        sb.append(':');
        sb.append(project.getVersion());
        return sb.toString();
    }
}

