/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.util;

import java.util.Random;
import net.jradius.log.RadiusLog;
import net.jradius.util.RadiusUtils;

public class RadiusRandom {
    static final Random rand = new Random();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(int length) {
        byte[] result = new byte[length];
        Random random = rand;
        synchronized (random) {
            for (int i = 0; i < length; ++i) {
                try {
                    int n = i;
                    result[n] = (byte)(result[n] ^ rand.nextInt());
                    continue;
                }
                catch (Exception e) {
                    RadiusLog.error("Invalid operation", e);
                }
            }
        }
        return result;
    }

    public static String getRandomPassword(int length) {
        String[] pseudo = new String[]{"2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "m", "n", "o", "p", "q", "r", "u", "s", "t", "v", "w", "x", "y", "z", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
        StringBuffer out = new StringBuffer(length);
        byte[] in = RadiusRandom.getBytes(length);
        for (int i = 0; i < length; ++i) {
            out.append(pseudo[(char)in[i] % pseudo.length]);
        }
        String rslt = new String(out);
        return rslt;
    }

    public static String getRandomPassword(int length, String allowedCharacters) {
        StringBuffer out = new StringBuffer(length);
        byte[] in = RadiusRandom.getBytes(length);
        for (int i = 0; i < length; ++i) {
            out.append(allowedCharacters.charAt((char)in[i] % allowedCharacters.length()));
        }
        String rslt = new String(out);
        return rslt;
    }

    public static String getRandomString(int length) {
        return RadiusUtils.byteArrayToHexString(RadiusRandom.getBytes(length));
    }
}

