/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.reporting.dao.jasper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.features.reporting.dao.jasper.LocalJasperReportsDao;
import org.opennms.features.reporting.model.jasperreport.JasperReportDefinition;
import org.opennms.features.reporting.model.jasperreport.LocalJasperReports;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class LegacyLocalJasperReportsDao
implements LocalJasperReportsDao {
    private Logger logger = LoggerFactory.getLogger(LegacyLocalJasperReportsDao.class);
    private LocalJasperReports m_LocalJasperReports;
    private Resource m_configResource;
    private Resource m_jrTemplateResource;

    public LegacyLocalJasperReportsDao(Resource configResource, Resource jrTemplateResource) {
        this.m_configResource = configResource;
        Assert.notNull((Object)this.m_configResource, (String)"property configResource must be set to a non-null value");
        this.m_jrTemplateResource = jrTemplateResource;
        Assert.notNull((Object)this.m_jrTemplateResource, (String)"property configResource must be sot to a non-null value");
        try {
            this.loadConfiguration();
        }
        catch (Exception e) {
            this.logger.error("Error could not load jasper-reports.xml. Error message: '{}'", (Object)e.getMessage());
        }
        this.logger.debug("Configuration '{}' successfully loaded and unmarshalled.", (Object)this.m_configResource.getFilename());
    }

    @Override
    public void loadConfiguration() throws Exception {
        File file = null;
        try {
            file = this.m_configResource.getFile();
        }
        catch (IOException e) {
            this.logger.error("Resource '{}' does not seem to have an underlying File object.", (Object)this.m_configResource, (Object)e);
            return;
        }
        this.setLocalJasperReports((LocalJasperReports)JaxbUtils.unmarshal(LocalJasperReports.class, (File)file));
        Assert.notNull((Object)this.m_LocalJasperReports, (String)"unmarshall config file returned a null value.");
        this.logger.debug("Unmarshalling config file '{}'", (Object)file.getAbsolutePath());
        this.logger.debug("Local report definitions assigned: '{}'", (Object)this.m_LocalJasperReports);
    }

    @Override
    public void setConfigResource(Resource configResource) {
        this.m_configResource = configResource;
    }

    @Override
    public Resource getConfigResource() {
        return this.m_configResource;
    }

    @Override
    public void setJrTemplateResource(Resource jrTemplateResource) {
        this.m_jrTemplateResource = jrTemplateResource;
    }

    @Override
    public Resource getJrTemplateResource() {
        return this.m_jrTemplateResource;
    }

    @Override
    public String getTemplateLocation(String id) {
        for (JasperReportDefinition report : this.m_LocalJasperReports.getReportList()) {
            if (!id.equals(report.getId())) continue;
            return report.getTemplate();
        }
        return null;
    }

    @Override
    public String getEngine(String id) {
        for (JasperReportDefinition report : this.m_LocalJasperReports.getReportList()) {
            if (!id.equals(report.getId())) continue;
            return report.getEngine();
        }
        return null;
    }

    @Override
    public InputStream getTemplateStream(String id) {
        try {
            String reportTemplateFolder = this.m_jrTemplateResource.getFile().getPath();
            for (JasperReportDefinition report : this.m_LocalJasperReports.getReportList()) {
                if (!id.equals(report.getId())) continue;
                try {
                    return new FileInputStream(new File(reportTemplateFolder + "/" + report.getTemplate()));
                }
                catch (FileNotFoundException e) {
                    this.logger.error("Template file '{}' at folder '{}' not found.", new Object[]{report.getTemplate(), reportTemplateFolder, e});
                }
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public LocalJasperReports getLocalJasperReports() {
        return this.m_LocalJasperReports;
    }

    public void setLocalJasperReports(LocalJasperReports localJasperReports) {
        this.m_LocalJasperReports = localJasperReports;
    }
}

