/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.IOException;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.actiond.ActiondConfiguration;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public final class ActiondConfigFactory {
    private static ActiondConfigFactory m_singleton = null;
    private ActiondConfiguration m_config;
    private static boolean m_loaded = false;

    private ActiondConfigFactory(String configFile) throws IOException {
        this.m_config = (ActiondConfiguration)JaxbUtils.unmarshal(ActiondConfiguration.class, (Resource)new FileSystemResource(configFile));
    }

    public static synchronized void init() throws IOException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.ACTIOND_CONFIG_FILE_NAME);
        m_singleton = new ActiondConfigFactory(cfgFile.getPath());
        m_loaded = true;
    }

    public static synchronized void reload() throws IOException {
        m_singleton = null;
        m_loaded = false;
        ActiondConfigFactory.init();
    }

    public static synchronized ActiondConfigFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public synchronized long getMaxProcessTime() {
        return this.m_config.getMaxProcessTime();
    }

    public synchronized int getMaxOutstandingActions() {
        return this.m_config.getMaxOutstandingActions();
    }
}

