/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.deviceconfig.sshscripting.impl;

import io.vavr.control.Either;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.opennms.features.deviceconfig.sshscripting.impl.SshInteraction;

class Statement {
    final StatementType statementType;
    final String string;

    static Either<List<String>, List<Statement>> parseScript(String script) {
        List l = Stream.of(script.split("\\\\n|\\n")).map(String::trim).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).map(line -> Pair.of((Object)line, (Object)Statement.parseStatement(line))).collect(Collectors.toList());
        List errs = l.stream().filter(pair -> pair.getRight() == null).map(Pair::getLeft).collect(Collectors.toList());
        if (!errs.isEmpty()) {
            return Either.left(errs);
        }
        return Either.right(l.stream().map(Pair::getRight).collect(Collectors.toList()));
    }

    static Statement parseStatement(String line) {
        for (StatementType p : StatementType.values()) {
            Statement s = p.parse(line);
            if (s == null) continue;
            return s;
        }
        return null;
    }

    Statement(StatementType statementType, String string) {
        this.statementType = statementType;
        this.string = string;
    }

    void execute(SshInteraction interaction) throws Exception {
        String s = interaction.replaceVars(this.string);
        this.statementType.execute(interaction, s);
    }

    public String toString() {
        return this.statementType.name() + ": " + this.string;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum StatementType {
        send{

            @Override
            public void execute(SshInteraction interaction, String string) throws Exception {
                interaction.sendLine(string);
            }
        }
        ,
        await{

            @Override
            public void execute(SshInteraction interaction, String string) throws Exception {
                interaction.await(string);
            }
        };


        public Statement parse(String line) {
            if (line.startsWith(this.name() + ":")) {
                String string = line.substring(this.name().length() + 1).trim();
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{string})) {
                    return new Statement(this, string);
                }
                return null;
            }
            return null;
        }

        public abstract void execute(SshInteraction var1, String var2) throws Exception;
    }
}

