/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl.resources;

import java.io.IOException;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.resources.ResourceHandler;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.parser.DrlParser;
import org.drools.drl.parser.DroolsParserException;
import org.drools.drl.parser.ParserError;
import org.drools.io.DescrResource;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;

public class DrlResourceHandler
extends ResourceHandler {
    public DrlResourceHandler(KnowledgeBuilderConfigurationImpl configuration) {
        super(configuration);
    }

    @Override
    public boolean handles(ResourceType type) {
        return type == ResourceType.DRL || type == ResourceType.GDRL || type == ResourceType.RDRL || type == ResourceType.DESCR || type == ResourceType.TDRL;
    }

    @Override
    public PackageDescr process(Resource resource, ResourceConfiguration resourceConfig) throws DroolsParserException, IOException {
        PackageDescr pkg;
        this.results.clear();
        boolean hasErrors = false;
        if (resource instanceof DescrResource) {
            pkg = (PackageDescr)((DescrResource)resource).getDescr();
        } else {
            DrlParser parser = new DrlParser(this.configuration.getLanguageLevel());
            pkg = parser.parse(resource);
            this.results.addAll(parser.getErrors());
            if (pkg == null) {
                this.results.add(new ParserError(resource, "Parser returned a null Package", 0, 0));
            }
            hasErrors = parser.hasErrors();
        }
        if (pkg != null) {
            pkg.setResource(resource);
        }
        return hasErrors ? null : pkg;
    }
}

