/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.mate.api;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.core.mate.api.ContextKey;
import org.opennms.core.mate.api.Scope;

public class MapScope
implements Scope {
    private final Scope.ScopeName scopeName;
    private final Map<ContextKey, String> values;

    public MapScope(Scope.ScopeName scopeName, Map<ContextKey, String> values) {
        this.scopeName = Objects.requireNonNull(scopeName);
        this.values = Objects.requireNonNull(values);
    }

    @Override
    public Optional<Scope.ScopeValue> get(ContextKey contextKey) {
        return Optional.ofNullable(this.values.get(contextKey)).map(value -> new Scope.ScopeValue(this.scopeName, (String)value));
    }

    @Override
    public Set<ContextKey> keys() {
        return this.values.keySet();
    }

    public static MapScope singleContext(Scope.ScopeName scopeName, String context, Map<String, String> values) {
        return new MapScope(scopeName, values.entrySet().stream().collect(Collectors.toMap(e -> new ContextKey(context, (String)e.getKey()), e -> (String)e.getValue())));
    }
}

