/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ackd.readers;

import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.opennms.core.spring.BeanUtils;
import org.opennms.netmgt.ackd.AckReader;
import org.opennms.netmgt.ackd.readers.AckProcessor;
import org.opennms.netmgt.ackd.readers.ReaderSchedule;
import org.opennms.netmgt.dao.api.AckdConfigurationDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class DefaultAckReader
implements AckReader,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAckReader.class);
    private volatile String m_name;
    private volatile Future<?> m_future;
    private AckProcessor m_ackProcessor;
    private ReaderSchedule m_schedule;
    private volatile AckReader.AckReaderState m_state = AckReader.AckReaderState.STOPPED;
    @Autowired
    private volatile AckdConfigurationDao m_ackdConfigDao;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
        boolean state = this.m_ackProcessor != null;
        Assert.state((boolean)state, (String)"Dependency injection failed; one or more fields are null.");
    }

    private synchronized void start(ScheduledThreadPoolExecutor executor) {
        if (this.m_schedule == null) {
            this.m_schedule = ReaderSchedule.createSchedule();
        }
        this.start(executor, this.m_schedule, true);
    }

    @Override
    public synchronized void start(ScheduledThreadPoolExecutor executor, ReaderSchedule schedule, boolean reloadConfig) throws IllegalStateException {
        if (reloadConfig) {
            LOG.info("start: reloading ack processor configuration...");
            this.m_ackProcessor.reloadConfigs();
            LOG.info("start: ack processor configuration reloaded.");
        }
        if (!AckReader.AckReaderState.STOPPED.equals((Object)this.getState())) {
            IllegalStateException e = new IllegalStateException("Reader is not in a stopped state.  Reader state is: " + String.valueOf((Object)this.getState()));
            LOG.error("start error", (Throwable)e);
            throw e;
        }
        this.setState(AckReader.AckReaderState.START_PENDING);
        this.setSchedule(executor, schedule, false);
        LOG.info("start: Starting reader...");
        this.scheduleReads(executor);
        this.setState(AckReader.AckReaderState.STARTED);
        LOG.info("start: Reader started.");
    }

    @Override
    public synchronized void pause() throws IllegalStateException {
        if (AckReader.AckReaderState.STARTED.equals((Object)this.getState()) || AckReader.AckReaderState.RESUMED.equals((Object)this.getState())) {
            LOG.info("pause: lock acquired; pausing reader...");
            this.setState(AckReader.AckReaderState.PAUSE_PENDING);
            if (this.m_future != null) {
                this.m_future.cancel(false);
                this.m_future = null;
            }
        } else {
            IllegalStateException e = new IllegalStateException("Reader is not in a running state (STARTED or RESUMED).  Reader state is: " + String.valueOf((Object)this.getState()));
            LOG.error("pause error", (Throwable)e);
            throw e;
        }
        this.setState(AckReader.AckReaderState.PAUSED);
        LOG.info("pause: Reader paused.");
    }

    @Override
    public synchronized void resume(ScheduledThreadPoolExecutor executor) throws IllegalStateException {
        if (!AckReader.AckReaderState.PAUSED.equals((Object)this.getState())) {
            IllegalStateException e = new IllegalStateException("Reader is not in a paused state, cannot resume.  Reader state is: " + String.valueOf((Object)this.getState()));
            LOG.error("resume error", (Throwable)e);
            throw e;
        }
        this.setState(AckReader.AckReaderState.RESUME_PENDING);
        LOG.info("resume: lock acquired; resuming reader...");
        this.scheduleReads(executor);
        this.setState(AckReader.AckReaderState.RESUMED);
        LOG.info("resume: reader resumed.");
    }

    @Override
    public synchronized void stop() throws IllegalStateException {
        if (!AckReader.AckReaderState.STOPPED.equals((Object)this.getState())) {
            this.setState(AckReader.AckReaderState.STOP_PENDING);
            LOG.info("stop: lock acquired; stopping reader...");
            if (this.m_future != null) {
                this.m_future.cancel(false);
                this.m_future = null;
            }
        } else {
            IllegalStateException e = new IllegalStateException("Reader is already stopped.");
            LOG.error("stop error", (Throwable)e);
            throw e;
        }
        this.setState(AckReader.AckReaderState.STOPPED);
        LOG.info("stop: Reader stopped.");
    }

    private synchronized void scheduleReads(ScheduledThreadPoolExecutor executor) {
        LOG.debug("scheduleReads: acquired lock, creating schedule...");
        executor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.m_future = executor.scheduleWithFixedDelay(this.getAckProcessor(), this.getSchedule().getInitialDelay(), this.getSchedule().getInterval(), this.getSchedule().getUnit());
        LOG.debug("scheduleReads: exited lock, schedule updated.");
        LOG.debug("scheduleReads: schedule is: attempts remaining: {}; initial delay: {}; interval: {}; unit: {}", new Object[]{this.getSchedule().getAttemptsRemaining(), this.getSchedule().getInitialDelay(), this.getSchedule().getInterval(), this.getSchedule().getUnit()});
        LOG.debug("scheduleReads: executor details: active count: {}; completed task count: {}; task count: {}; queue size: {}", new Object[]{executor.getActiveCount(), executor.getCompletedTaskCount(), executor.getTaskCount(), executor.getQueue().size()});
    }

    public String toString() {
        return this.getClass().getCanonicalName();
    }

    @Override
    public void setAckProcessor(AckProcessor ackProcessor) {
        this.m_ackProcessor = ackProcessor;
    }

    @Override
    public AckProcessor getAckProcessor() {
        return this.m_ackProcessor;
    }

    public void setAckdConfigDao(AckdConfigurationDao ackdConfigDao) {
        this.m_ackdConfigDao = ackdConfigDao;
    }

    public AckdConfigurationDao getAckdConfigDao() {
        return this.m_ackdConfigDao;
    }

    private synchronized void setSchedule(ScheduledThreadPoolExecutor executor, ReaderSchedule schedule, boolean reschedule) {
        this.m_schedule = schedule;
        if (reschedule) {
            this.stop();
            this.start(executor);
        }
    }

    private ReaderSchedule getSchedule() {
        if (this.m_schedule == null) {
            this.m_schedule = ReaderSchedule.createSchedule();
        }
        return this.m_schedule;
    }

    private synchronized void setState(AckReader.AckReaderState state) {
        this.m_state = state;
    }

    @Override
    public AckReader.AckReaderState getState() {
        return this.m_state;
    }

    public Future<?> getFuture() {
        return this.m_future;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public synchronized void setName(String name) {
        this.m_name = name;
    }
}

