/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml;

import java.io.IOException;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.common.SAMLException;
import org.opensaml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.util.URLBuilder;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.ws.transport.http.HTTPInTransport;
import org.opensaml.ws.transport.http.HTTPOutTransport;
import org.opensaml.ws.transport.http.HttpServletRequestAdapter;
import org.opensaml.xml.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.saml.SAMLDiscovery;
import org.springframework.security.saml.context.SAMLContextProvider;
import org.springframework.security.saml.context.SAMLMessageContext;
import org.springframework.security.saml.log.SAMLLogger;
import org.springframework.security.saml.metadata.MetadataManager;
import org.springframework.security.saml.util.SAMLUtil;
import org.springframework.security.saml.websso.WebSSOProfile;
import org.springframework.security.saml.websso.WebSSOProfileOptions;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.FilterInvocation;
import org.springframework.util.Assert;
import org.springframework.web.filter.GenericFilterBean;

public class SAMLEntryPoint
extends GenericFilterBean
implements AuthenticationEntryPoint {
    protected static final Logger log = LoggerFactory.getLogger(SAMLEntryPoint.class);
    protected WebSSOProfileOptions defaultOptions;
    protected WebSSOProfile webSSOprofile;
    protected WebSSOProfile webSSOprofileECP;
    protected WebSSOProfile webSSOprofileHoK;
    protected MetadataManager metadata;
    protected SAMLLogger samlLogger;
    protected SAMLContextProvider contextProvider;
    protected SAMLDiscovery samlDiscovery;
    protected String filterProcessesUrl = "/saml/login";
    public static final String FILTER_URL = "/saml/login";
    public static final String IDP_PARAMETER = "idp";
    public static final String DISCOVERY_RESPONSE_PARAMETER = "disco";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        FilterInvocation fi = new FilterInvocation(request, response, chain);
        if (!this.processFilter(fi.getRequest())) {
            chain.doFilter(request, response);
            return;
        }
        this.commence(fi.getRequest(), fi.getResponse(), null);
    }

    protected boolean processFilter(HttpServletRequest request) {
        return SAMLUtil.processFilter(this.filterProcessesUrl, request);
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException e) throws IOException, ServletException {
        try {
            SAMLMessageContext context = this.contextProvider.getLocalAndPeerEntity(request, response);
            if (this.isECP(context)) {
                this.initializeECP(context, e);
            } else if (this.isDiscovery(context)) {
                this.initializeDiscovery(context);
            } else {
                this.initializeSSO(context, e);
            }
        }
        catch (SAMLException e1) {
            log.debug("Error initializing entry point", (Throwable)e1);
            throw new ServletException((Throwable)e1);
        }
        catch (MetadataProviderException e1) {
            log.debug("Error initializing entry point", (Throwable)e1);
            throw new ServletException((Throwable)e1);
        }
        catch (MessageEncodingException e1) {
            log.debug("Error initializing entry point", (Throwable)e1);
            throw new ServletException((Throwable)e1);
        }
    }

    protected void initializeECP(SAMLMessageContext context, AuthenticationException e) throws MetadataProviderException, SAMLException, MessageEncodingException {
        WebSSOProfileOptions options = this.getProfileOptions(context, e);
        log.debug("Processing SSO using ECP profile");
        this.webSSOprofileECP.sendAuthenticationRequest(context, options);
        this.samlLogger.log("AuthNRequest", "SUCCESS", context);
    }

    protected void initializeSSO(SAMLMessageContext context, AuthenticationException e) throws MetadataProviderException, SAMLException, MessageEncodingException {
        WebSSOProfileOptions options = this.getProfileOptions(context, e);
        AssertionConsumerService consumerService = SAMLUtil.getConsumerService((SPSSODescriptor)context.getLocalEntityRoleMetadata(), options.getAssertionConsumerIndex());
        if ("urn:oasis:names:tc:SAML:2.0:profiles:holder-of-key:SSO:browser".equals(consumerService.getBinding())) {
            if (this.webSSOprofileHoK == null) {
                log.warn("WebSSO HoK profile was specified to be used, but profile is not configured in the EntryPoint, HoK will be skipped");
            } else {
                log.debug("Processing SSO using WebSSO HolderOfKey profile");
                this.webSSOprofileHoK.sendAuthenticationRequest(context, options);
                this.samlLogger.log("AuthNRequest", "SUCCESS", context);
                return;
            }
        }
        log.debug("Processing SSO using WebSSO profile");
        this.webSSOprofile.sendAuthenticationRequest(context, options);
        this.samlLogger.log("AuthNRequest", "SUCCESS", context);
    }

    protected void initializeDiscovery(SAMLMessageContext context) throws ServletException, IOException, MetadataProviderException {
        String discoveryURL = context.getLocalExtendedMetadata().getIdpDiscoveryURL();
        if (discoveryURL != null) {
            URLBuilder urlBuilder = new URLBuilder(discoveryURL);
            List queryParams = urlBuilder.getQueryParams();
            queryParams.add(new Pair((Object)"entityID", (Object)context.getLocalEntityId()));
            queryParams.add(new Pair((Object)"returnIDParam", (Object)IDP_PARAMETER));
            discoveryURL = urlBuilder.buildURL();
            log.debug("Using discovery URL from extended metadata");
        } else {
            String discoveryUrl = "/saml/discovery";
            if (this.samlDiscovery != null) {
                discoveryUrl = this.samlDiscovery.getFilterProcessesUrl();
            }
            String contextPath = (String)context.getInboundMessageTransport().getAttribute("localContextPath");
            discoveryURL = contextPath + discoveryUrl + "?" + "returnIDParam" + "=" + IDP_PARAMETER + "&" + "entityID" + "=" + context.getLocalEntityId();
            log.debug("Using local discovery URL");
        }
        log.debug("Redirecting to discovery URL {}", (Object)discoveryURL);
        HTTPOutTransport response = (HTTPOutTransport)context.getOutboundMessageTransport();
        response.sendRedirect(discoveryURL);
    }

    protected WebSSOProfileOptions getProfileOptions(SAMLMessageContext context, AuthenticationException exception) throws MetadataProviderException {
        WebSSOProfileOptions ssoProfileOptions = this.defaultOptions != null ? this.defaultOptions.clone() : new WebSSOProfileOptions();
        return ssoProfileOptions;
    }

    public void setDefaultProfileOptions(WebSSOProfileOptions defaultOptions) {
        this.defaultOptions = defaultOptions != null ? defaultOptions.clone() : null;
    }

    protected boolean isDiscovery(SAMLMessageContext context) {
        return !context.isPeerUserSelected() && context.getLocalExtendedMetadata().isIdpDiscoveryEnabled() && !this.isDiscoResponse(context);
    }

    protected boolean isECP(SAMLMessageContext context) {
        boolean ecp;
        HttpServletRequest request = ((HttpServletRequestAdapter)context.getInboundMessageTransport()).getWrappedRequest();
        boolean bl = ecp = context.getLocalExtendedMetadata().isEcpEnabled() && SAMLUtil.isECPRequest(request);
        if (ecp) {
            if (this.webSSOprofileECP == null) {
                log.warn("ECP profile was specified to be used, but profile is not configured in the EntryPoint, ECP will be skipped");
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isDiscoResponse(SAMLMessageContext context) {
        HTTPInTransport request = (HTTPInTransport)context.getInboundMessageTransport();
        String disco = request.getParameterValue(DISCOVERY_RESPONSE_PARAMETER);
        return disco != null && disco.toLowerCase().trim().equals("true");
    }

    @Autowired
    @Qualifier(value="webSSOprofile")
    public void setWebSSOprofile(WebSSOProfile webSSOprofile) {
        Assert.notNull((Object)webSSOprofile, (String)"WebSSOPRofile can't be null");
        this.webSSOprofile = webSSOprofile;
    }

    @Autowired(required=false)
    @Qualifier(value="ecpprofile")
    public void setWebSSOprofileECP(WebSSOProfile webSSOprofileECP) {
        this.webSSOprofileECP = webSSOprofileECP;
    }

    @Autowired(required=false)
    @Qualifier(value="hokWebSSOProfile")
    public void setWebSSOprofileHoK(WebSSOProfile webSSOprofileHoK) {
        this.webSSOprofileHoK = webSSOprofileHoK;
    }

    @Autowired
    public void setSamlLogger(SAMLLogger samlLogger) {
        Assert.notNull((Object)samlLogger, (String)"SAML Logger can't be null");
        this.samlLogger = samlLogger;
    }

    @Autowired(required=false)
    public void setSamlDiscovery(SAMLDiscovery samlDiscovery) {
        this.samlDiscovery = samlDiscovery;
    }

    @Autowired
    public void setContextProvider(SAMLContextProvider contextProvider) {
        Assert.notNull((Object)contextProvider, (String)"Context provider can't be null");
        this.contextProvider = contextProvider;
    }

    @Autowired
    public void setMetadata(MetadataManager metadata) {
        Assert.notNull((Object)metadata, (String)"MetadataManager can't be null");
        this.metadata = metadata;
    }

    public String getFilterProcessesUrl() {
        return this.filterProcessesUrl;
    }

    public void setFilterProcessesUrl(String filterProcessesUrl) {
        this.filterProcessesUrl = filterProcessesUrl;
    }

    public void afterPropertiesSet() throws ServletException {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.webSSOprofile, (String)"WebSSO profile must be set");
        Assert.notNull((Object)this.metadata, (String)"Metadata must be set");
        Assert.notNull((Object)this.samlLogger, (String)"Logger must be set");
        Assert.notNull((Object)this.contextProvider, (String)"Context provider must be set");
    }
}

