/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.icmp;

import java.util.Date;
import org.opennms.protocols.icmp.ICMPHeader;
import org.opennms.protocols.ip.OC16ChecksumProducer;

public final class TimestampRequest
extends ICMPHeader {
    private int m_origStamp;

    public TimestampRequest() {
        super((byte)13, (byte)0);
        this.m_origStamp = (int)(new Date().getTime() & 0xFFFFFFFFFFFFFFFFL);
    }

    public TimestampRequest(byte[] buf, int offset) {
        this.loadFromBuffer(buf, offset);
    }

    @Override
    public final void computeChecksum() {
        OC16ChecksumProducer summer = new OC16ChecksumProducer();
        super.computeChecksum(summer);
        summer.add(this.m_origStamp);
        summer.add(0);
        summer.add(0);
        this.setChecksum(summer.getChecksum());
    }

    @Override
    public final int storeToBuffer(byte[] buf, int offset) {
        if (buf.length < offset + 20) {
            throw new IndexOutOfBoundsException("Array index overflow in buffer build");
        }
        this.computeChecksum();
        offset = super.storeToBuffer(buf, offset);
        buf[offset++] = (byte)(this.m_origStamp >> 24 & 0xFF);
        buf[offset++] = (byte)(this.m_origStamp >> 16 & 0xFF);
        buf[offset++] = (byte)(this.m_origStamp >> 8 & 0xFF);
        buf[offset++] = (byte)(this.m_origStamp & 0xFF);
        for (int x = 0; x < 8; ++x) {
            buf[offset++] = 0;
        }
        return offset;
    }

    @Override
    public final int loadFromBuffer(byte[] buf, int offset) {
        if (buf.length < offset + 20) {
            throw new IndexOutOfBoundsException("Insufficient data to load ICMP header");
        }
        offset = super.loadFromBuffer(buf, offset);
        if (this.getType() != 13) {
            throw new IllegalArgumentException("The buffer did not contain an Timestamp Request");
        }
        this.m_origStamp = TimestampRequest.byteToInt(buf[offset++]) << 24 | TimestampRequest.byteToInt(buf[offset++]) << 16 | TimestampRequest.byteToInt(buf[offset++]) << 8 | TimestampRequest.byteToInt(buf[offset++]);
        return offset += 8;
    }

    public final void setOriginateTS() {
        this.m_origStamp = (int)(new Date().getTime() & 0xFFFFFFFFFFFFFFFFL);
    }

    public final void setOriginateTS(int ts) {
        this.m_origStamp = ts;
    }

    public final int getOriginateTS() {
        return this.m_origStamp;
    }

    @Override
    public final byte[] toBytes() {
        byte[] b = new byte[20];
        this.storeToBuffer(b, 0);
        return b;
    }
}

