/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.address;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.util.Cache;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.address.MultipleRecipientInfo;
import org.jivesoftware.smackx.address.packet.MultipleAddresses;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;

public class MultipleRecipientManager {
    private static final Logger LOGGER = Logger.getLogger(MultipleRecipientManager.class.getName());
    private static Cache<String, String> services = new Cache(100, 86400000L);

    public static void send(XMPPConnection connection, Packet packet, List<String> to, List<String> cc, List<String> bcc) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.FeatureNotSupportedException, SmackException.NotConnectedException {
        MultipleRecipientManager.send(connection, packet, to, cc, bcc, null, null, false);
    }

    public static void send(XMPPConnection connection, Packet packet, List<String> to, List<String> cc, List<String> bcc, String replyTo, String replyRoom, boolean noReply) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.FeatureNotSupportedException, SmackException.NotConnectedException {
        String serviceAddress = MultipleRecipientManager.getMultipleRecipienServiceAddress(connection);
        if (serviceAddress != null) {
            MultipleRecipientManager.sendThroughService(connection, packet, to, cc, bcc, replyTo, replyRoom, noReply, serviceAddress);
        } else {
            if (noReply || replyTo != null && replyTo.trim().length() > 0 || replyRoom != null && replyRoom.trim().length() > 0) {
                throw new SmackException.FeatureNotSupportedException("Extended Stanza Addressing");
            }
            MultipleRecipientManager.sendToIndividualRecipients(connection, packet, to, cc, bcc);
        }
    }

    public static void reply(XMPPConnection connection, Message original, Message reply) throws SmackException, XMPPException.XMPPErrorException {
        MultipleAddresses.Address replyAddress;
        MultipleRecipientInfo info = MultipleRecipientManager.getMultipleRecipientInfo((Packet)original);
        if (info == null) {
            throw new SmackException("Original message does not contain multiple recipient info");
        }
        if (info.shouldNotReply()) {
            throw new SmackException("Original message should not be replied");
        }
        if (info.getReplyRoom() != null) {
            throw new SmackException("Reply should be sent through a room");
        }
        if (original.getThread() != null) {
            reply.setThread(original.getThread());
        }
        if ((replyAddress = info.getReplyAddress()) != null && replyAddress.getJid() != null) {
            reply.setTo(replyAddress.getJid());
            connection.sendPacket((Packet)reply);
        } else {
            String serviceAddress;
            String from;
            String jid;
            ArrayList<String> to = new ArrayList<String>();
            ArrayList<String> cc = new ArrayList<String>();
            Iterator<MultipleAddresses.Address> it = info.getTOAddresses().iterator();
            while (it.hasNext()) {
                jid = it.next().getJid();
                to.add(jid);
            }
            it = info.getCCAddresses().iterator();
            while (it.hasNext()) {
                jid = it.next().getJid();
                cc.add(jid);
            }
            if (!to.contains(original.getFrom()) && !cc.contains(original.getFrom())) {
                to.add(original.getFrom());
            }
            if (!to.remove(from = connection.getUser()) && !cc.remove(from)) {
                String bareJID = StringUtils.parseBareAddress((String)from);
                to.remove(bareJID);
                cc.remove(bareJID);
            }
            if ((serviceAddress = MultipleRecipientManager.getMultipleRecipienServiceAddress(connection)) != null) {
                MultipleRecipientManager.sendThroughService(connection, (Packet)reply, to, cc, null, null, null, false, serviceAddress);
            } else {
                MultipleRecipientManager.sendToIndividualRecipients(connection, (Packet)reply, to, cc, null);
            }
        }
    }

    public static MultipleRecipientInfo getMultipleRecipientInfo(Packet packet) {
        MultipleAddresses extension = (MultipleAddresses)packet.getExtension("addresses", "http://jabber.org/protocol/address");
        return extension == null ? null : new MultipleRecipientInfo(extension);
    }

    private static void sendToIndividualRecipients(XMPPConnection connection, Packet packet, List<String> to, List<String> cc, List<String> bcc) throws SmackException.NotConnectedException {
        if (to != null) {
            for (String jid : to) {
                packet.setTo(jid);
                connection.sendPacket((Packet)new PacketCopy(packet.toXML()));
            }
        }
        if (cc != null) {
            for (String jid : cc) {
                packet.setTo(jid);
                connection.sendPacket((Packet)new PacketCopy(packet.toXML()));
            }
        }
        if (bcc != null) {
            for (String jid : bcc) {
                packet.setTo(jid);
                connection.sendPacket((Packet)new PacketCopy(packet.toXML()));
            }
        }
    }

    private static void sendThroughService(XMPPConnection connection, Packet packet, List<String> to, List<String> cc, List<String> bcc, String replyTo, String replyRoom, boolean noReply, String serviceAddress) throws SmackException.NotConnectedException {
        MultipleAddresses multipleAddresses = new MultipleAddresses();
        if (to != null) {
            for (String jid : to) {
                multipleAddresses.addAddress("to", jid, null, null, false, null);
            }
        }
        if (cc != null) {
            for (String jid : cc) {
                multipleAddresses.addAddress("cc", jid, null, null, false, null);
            }
        }
        if (bcc != null) {
            for (String jid : bcc) {
                multipleAddresses.addAddress("bcc", jid, null, null, false, null);
            }
        }
        if (noReply) {
            multipleAddresses.setNoReply();
        } else {
            if (replyTo != null && replyTo.trim().length() > 0) {
                multipleAddresses.addAddress("replyto", replyTo, null, null, false, null);
            }
            if (replyRoom != null && replyRoom.trim().length() > 0) {
                multipleAddresses.addAddress("replyroom", replyRoom, null, null, false, null);
            }
        }
        packet.setTo(serviceAddress);
        packet.addExtension((PacketExtension)multipleAddresses);
        connection.sendPacket(packet);
    }

    private static String getMultipleRecipienServiceAddress(XMPPConnection connection) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        String serviceName = connection.getServiceName();
        String serviceAddress = (String)services.get((Object)serviceName);
        if (serviceAddress == null) {
            ServiceDiscoveryManager sdm = ServiceDiscoveryManager.getInstanceFor(connection);
            DiscoverInfo info = null;
            try {
                info = sdm.discoverInfo(serviceName);
            }
            catch (XMPPException.XMPPErrorException e) {
                LOGGER.log(Level.WARNING, "Exception while discovering info of service", e);
            }
            if (info != null && info.containsFeature("http://jabber.org/protocol/address")) {
                serviceAddress = serviceName;
            } else {
                try {
                    DiscoverItems items = sdm.discoverItems(serviceName);
                    for (DiscoverItems.Item item : items.getItems()) {
                        try {
                            info = sdm.discoverInfo(item.getEntityID(), item.getNode());
                        }
                        catch (SmackException.NoResponseException | XMPPException.XMPPErrorException e) {
                            LOGGER.log(Level.WARNING, "Exception while discovering info of " + item.getEntityID() + " node: " + item.getNode(), e);
                            continue;
                        }
                        if (!info.containsFeature("http://jabber.org/protocol/address")) continue;
                        serviceAddress = serviceName;
                        break;
                    }
                }
                catch (XMPPException.XMPPErrorException e) {
                    LOGGER.log(Level.WARNING, "Exception while disvering items of service", e);
                }
            }
            serviceAddress = serviceAddress == null ? "" : serviceAddress;
            services.put((Object)serviceName, (Object)serviceAddress);
        }
        return "".equals(serviceAddress) ? null : serviceAddress;
    }

    private static class PacketCopy
    extends Packet {
        private CharSequence text;

        public PacketCopy(CharSequence text) {
            this.text = text;
        }

        public CharSequence toXML() {
            return this.text;
        }
    }
}

