/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.transaction.local;

import java.util.List;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import net.sf.ehcache.TransactionController;
import net.sf.ehcache.store.ElementValueComparator;
import net.sf.ehcache.transaction.AbstractTransactionStore;
import net.sf.ehcache.transaction.TransactionException;
import net.sf.ehcache.transaction.TransactionID;
import net.sf.ehcache.transaction.local.LocalTransactionStore;
import net.sf.ehcache.transaction.manager.TransactionManagerLookup;
import net.sf.ehcache.writer.CacheWriterManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JtaLocalTransactionStore
extends AbstractTransactionStore {
    private static final Logger LOG = LoggerFactory.getLogger((String)JtaLocalTransactionStore.class.getName());
    private static final ThreadLocal<Transaction> BOUND_JTA_TRANSACTIONS = new ThreadLocal();
    private final TransactionController transactionController;
    private final TransactionManager transactionManager;

    public JtaLocalTransactionStore(LocalTransactionStore underlyingStore, TransactionManagerLookup transactionManagerLookup, TransactionController transactionController) {
        super(underlyingStore);
        this.transactionController = transactionController;
        this.transactionManager = transactionManagerLookup.getTransactionManager();
        if (this.transactionManager == null) {
            throw new TransactionException("no JTA transaction manager could be located, cannot bind local_jta cache with JTA");
        }
    }

    private void registerInJtaContext() {
        try {
            if (this.transactionController.getCurrentTransactionContext() != null) {
                Transaction tx = this.transactionManager.getTransaction();
                if (!BOUND_JTA_TRANSACTIONS.get().equals(tx)) {
                    throw new TransactionException("Invalid JTA transaction context, cache was first used in transaction [" + BOUND_JTA_TRANSACTIONS + "]" + " but is now used in transaction [" + tx + "].");
                }
            } else {
                Transaction tx = this.transactionManager.getTransaction();
                if (tx == null) {
                    throw new TransactionException("no JTA transaction context started, local_jta caches cannot be used outside of JTA transactions");
                }
                BOUND_JTA_TRANSACTIONS.set(tx);
                this.transactionController.begin();
                tx.registerSynchronization((Synchronization)new JtaLocalEhcacheSynchronization(this.transactionController, this.transactionController.getCurrentTransactionContext().getTransactionId()));
            }
        }
        catch (SystemException e) {
            throw new TransactionException("internal JTA transaction manager error, cannot bind local_jta cache with it", e);
        }
        catch (RollbackException e) {
            throw new TransactionException("JTA transaction rolled back, cannot bind local_jta cache with it", e);
        }
    }

    private void setRollbackOnly() {
        try {
            BOUND_JTA_TRANSACTIONS.get().setRollbackOnly();
            this.transactionController.setRollbackOnly();
        }
        catch (SystemException e) {
            LOG.warn("internal JTA transaction manager error", (Throwable)e);
        }
    }

    public boolean put(Element element) throws CacheException {
        this.registerInJtaContext();
        try {
            return this.underlyingStore.put(element);
        }
        catch (CacheException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public boolean putWithWriter(Element element, CacheWriterManager writerManager) throws CacheException {
        this.registerInJtaContext();
        try {
            return this.underlyingStore.putWithWriter(element, writerManager);
        }
        catch (CacheException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Element get(Object key) {
        this.registerInJtaContext();
        try {
            return this.underlyingStore.get(key);
        }
        catch (CacheException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Element getQuiet(Object key) {
        this.registerInJtaContext();
        try {
            return this.underlyingStore.getQuiet(key);
        }
        catch (CacheException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public List getKeys() {
        this.registerInJtaContext();
        try {
            return this.underlyingStore.getKeys();
        }
        catch (CacheException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Element remove(Object key) {
        this.registerInJtaContext();
        try {
            return this.underlyingStore.remove(key);
        }
        catch (CacheException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Element removeWithWriter(Object key, CacheWriterManager writerManager) throws CacheException {
        this.registerInJtaContext();
        try {
            return this.underlyingStore.removeWithWriter(key, writerManager);
        }
        catch (CacheException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public void removeAll() throws CacheException {
        this.registerInJtaContext();
        try {
            this.underlyingStore.removeAll();
        }
        catch (CacheException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Element putIfAbsent(Element element) throws NullPointerException {
        this.registerInJtaContext();
        try {
            return this.underlyingStore.putIfAbsent(element);
        }
        catch (CacheException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Element removeElement(Element element, ElementValueComparator comparator) throws NullPointerException {
        this.registerInJtaContext();
        try {
            return this.underlyingStore.removeElement(element, comparator);
        }
        catch (CacheException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public boolean replace(Element old, Element element, ElementValueComparator comparator) throws NullPointerException, IllegalArgumentException {
        this.registerInJtaContext();
        try {
            return this.underlyingStore.replace(old, element, comparator);
        }
        catch (CacheException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Element replace(Element element) throws NullPointerException {
        this.registerInJtaContext();
        try {
            return this.underlyingStore.replace(element);
        }
        catch (CacheException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public int getSize() {
        this.registerInJtaContext();
        try {
            return this.underlyingStore.getSize();
        }
        catch (CacheException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public int getTerracottaClusteredSize() {
        this.registerInJtaContext();
        try {
            return this.underlyingStore.getTerracottaClusteredSize();
        }
        catch (CacheException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public boolean containsKey(Object key) {
        this.registerInJtaContext();
        try {
            return this.underlyingStore.containsKey(key);
        }
        catch (CacheException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    private static class JtaLocalEhcacheSynchronization
    implements Synchronization {
        private final TransactionController transactionController;
        private final TransactionID transactionId;

        public JtaLocalEhcacheSynchronization(TransactionController transactionController, TransactionID transactionId) {
            this.transactionController = transactionController;
            this.transactionId = transactionId;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            BOUND_JTA_TRANSACTIONS.remove();
            if (status == 3) {
                this.transactionController.commit(true);
            } else {
                this.transactionController.rollback();
            }
        }

        public String toString() {
            return "JtaLocalEhcacheSynchronization of transaction [" + this.transactionId + "]";
        }
    }
}

